/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer;

import java.util.Collection;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.scada.chart.swt.ChartRenderer;

public abstract class AbstractAxisManager<Key, Value> {
    private final WritableList list = new WritableList();
    protected final DataBindingContext dbc;
    protected final ChartRenderer manager;
    private IListChangeListener listener;

    public AbstractAxisManager(DataBindingContext dbc, ChartRenderer manager) {
        this.dbc = dbc;
        this.manager = manager;
        this.listener = new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                AbstractAxisManager.this.handleListeChange(event.diff);
            }
        };
        this.list.addListChangeListener(this.listener);
    }

    protected void handleListeChange(ListDiff diff) {
        diff.accept(new ListDiffVisitor(){

            public void handleRemove(int index, Object element) {
                AbstractAxisManager.this.handleRemove(element);
            }

            public void handleAdd(int index, Object element) {
                AbstractAxisManager.this.handleAdd(index, element);
            }
        });
    }

    protected abstract void handleAdd(int var1, Key var2);

    protected abstract void handleRemove(Key var1);

    public abstract Collection<Value> getAll();

    public void dispose() {
        this.list.removeListChangeListener(this.listener);
    }

    public WritableList getList() {
        return this.list;
    }

    public abstract Value getAxis(Key var1);
}

