/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.hd.ui.connection.data.Item;
import org.eclipse.scada.ui.chart.model.ArchiveChannel;
import org.eclipse.scada.ui.chart.model.ArchiveSeries;
import org.eclipse.scada.ui.chart.model.ChartPackage;
import org.eclipse.scada.ui.chart.model.IdItem;
import org.eclipse.scada.ui.chart.model.Item;
import org.eclipse.scada.ui.chart.model.ItemDataSeries;
import org.eclipse.scada.ui.chart.model.UriItem;
import org.eclipse.scada.ui.chart.model.XAxis;
import org.eclipse.scada.ui.chart.model.YAxis;
import org.eclipse.scada.ui.chart.viewer.AbstractItemInputViewer;
import org.eclipse.scada.ui.chart.viewer.ArchiveChannelViewer;
import org.eclipse.scada.ui.chart.viewer.AxisLocator;
import org.eclipse.scada.ui.chart.viewer.ChartViewer;
import org.eclipse.scada.ui.chart.viewer.LinePropertiesBinder;
import org.eclipse.scada.ui.chart.viewer.XAxisViewer;
import org.eclipse.scada.ui.chart.viewer.YAxisViewer;
import org.eclipse.scada.ui.chart.viewer.input.ArchiveInput;
import org.eclipse.scada.ui.chart.viewer.input.ChartInput;
import org.eclipse.scada.ui.chart.viewer.input.QuerySeriesData;
import org.eclipse.swt.widgets.Display;

public class ArchiveSeriesViewer
extends AbstractItemInputViewer {
    public static final String PROP_INPUT = "input";
    public static final String PROP_QUERY_SERIES_DATA = "querySeriesData";
    private final WritableList channels = new WritableList();
    private final Map<ArchiveChannel, ArchiveChannelViewer> viewerMap = new HashMap<ArchiveChannel, ArchiveChannelViewer>();
    private final DataBindingContext dbc;
    private QuerySeriesData querySeriesData;
    private final IObservableValue inputObservable;
    private final IObservableValue linePropertiesObservable;
    private ArchiveInput input;

    public ArchiveSeriesViewer(DataBindingContext dbc, ArchiveSeries element, ChartViewer viewer, ResourceManager resourceManager, AxisLocator<XAxis, XAxisViewer> xLocator, AxisLocator<YAxis, YAxisViewer> yLocator) {
        super(dbc, (ItemDataSeries)element, viewer, resourceManager, xLocator, yLocator);
        this.dbc = dbc;
        this.channels.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                event.diff.accept(new ListDiffVisitor(){

                    public void handleRemove(int index, Object element) {
                        ArchiveSeriesViewer.this.handleRemoveChannel((ArchiveChannel)element);
                    }

                    public void handleAdd(int index, Object element) {
                        ArchiveSeriesViewer.this.handleAddChannel((ArchiveChannel)element);
                    }
                });
            }
        });
        this.addBinding(dbc.bindList((IObservableList)this.channels, EMFObservables.observeList((EObject)element, (EStructuralFeature)ChartPackage.Literals.ARCHIVE_SERIES__CHANNELS)));
        this.inputObservable = BeansObservables.observeValue((Object)this, (String)PROP_INPUT);
        this.linePropertiesObservable = EMFObservables.observeValue((EObject)element, (EStructuralFeature)ChartPackage.Literals.ARCHIVE_SERIES__LINE_PROPERTIES);
        this.addBindings(LinePropertiesBinder.bind(SWTObservables.getRealm((Display)viewer.getChartRenderer().getDisplay()), dbc, this.inputObservable, this.linePropertiesObservable));
        this.setInputObserable(this.inputObservable);
    }

    protected void handleAddChannel(ArchiveChannel channel) {
        ArchiveChannelViewer viewer = new ArchiveChannelViewer(this.dbc, channel, this.viewer, this.resourceManager, this);
        ArchiveChannelViewer oldViewer = this.viewerMap.put(channel, viewer);
        if (oldViewer != null) {
            oldViewer.dispose();
        }
    }

    protected void handleRemoveChannel(ArchiveChannel channel) {
        ArchiveChannelViewer viewer = this.viewerMap.remove(channel);
        if (viewer != null) {
            viewer.dispose();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.inputObservable.dispose();
        this.linePropertiesObservable.dispose();
        this.channels.dispose();
    }

    @Override
    protected void checkCreateInput() {
        if (this.item != null && this.xAxis != null && this.yAxis != null) {
            org.eclipse.scada.hd.ui.connection.data.Item item = this.makeItem(this.item);
            if (item == null) {
                return;
            }
            this.setQuerySeriesData(new QuerySeriesData(item, this.viewer.getRealm(), this.xAxis.getAxis(), this.yAxis.getAxis()));
            ArchiveInput input = new ArchiveInput(item, this.viewer, this.querySeriesData, this.resourceManager);
            this.viewer.addInput(input);
            this.setInput(input);
        }
    }

    private void setInput(ArchiveInput input) {
        this.input = input;
        this.firePropertyChange(PROP_INPUT, this.input, this.input);
    }

    public ArchiveInput getInput() {
        return this.input;
    }

    private org.eclipse.scada.hd.ui.connection.data.Item makeItem(Item item) {
        if (item instanceof IdItem) {
            return new org.eclipse.scada.hd.ui.connection.data.Item(((IdItem)item).getConnectionId(), item.getItemId(), Item.Type.ID);
        }
        if (item instanceof UriItem) {
            return new org.eclipse.scada.hd.ui.connection.data.Item(((UriItem)item).getConnectionUri(), item.getItemId(), Item.Type.URI);
        }
        return null;
    }

    @Override
    protected void disposeInput() {
        if (this.input != null) {
            this.viewer.removeInput(this.input);
            this.input.dispose();
            this.setInput(null);
        }
        if (this.querySeriesData != null) {
            this.querySeriesData.dispose();
            this.setQuerySeriesData(null);
        }
    }

    @Override
    public boolean provides(ChartInput input) {
        return this.input == input;
    }

    public QuerySeriesData getQuerySeriesData() {
        return this.querySeriesData;
    }

    public void setQuerySeriesData(QuerySeriesData querySeriesData) {
        this.querySeriesData = querySeriesData;
        this.firePropertyChange(PROP_QUERY_SERIES_DATA, (Object)querySeriesData, (Object)this.querySeriesData);
    }
}

