/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.input;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.chart.AbstractSeriesData;
import org.eclipse.scada.chart.DataEntry;
import org.eclipse.scada.chart.Realm;
import org.eclipse.scada.chart.SeriesViewData;
import org.eclipse.scada.chart.WritableSeriesData;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.connection.provider.ConnectionRequest;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.data.ValueInformation;
import org.eclipse.scada.hd.ui.connection.data.Item;
import org.eclipse.scada.hd.ui.data.ServiceQueryBuffer;
import org.eclipse.scada.ui.chart.Activator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySeriesData
extends AbstractSeriesData {
    private static final Logger logger = LoggerFactory.getLogger(QuerySeriesData.class);
    private final ServiceQueryBuffer query;
    private QueryParameters parameters;
    private QueryParameters nextParameters;
    private final Item item;

    public QuerySeriesData(Item item, Realm realm, XAxis xAxis, YAxis yAxis) {
        super(realm, xAxis, yAxis);
        this.item = item;
        this.parameters = this.makeInitialParameters();
        switch (item.getType()) {
            case ID: {
                this.parameters = this.makeInitialParameters();
                this.query = new ServiceQueryBuffer(Activator.getDefault().getBundle().getBundleContext(), item.getConnectionString(), item.getId(), this.parameters);
                break;
            }
            default: {
                this.parameters = this.makeInitialParameters();
                this.query = new ServiceQueryBuffer(Activator.getDefault().getBundle().getBundleContext(), this.createRequest(), item.getId(), this.parameters);
            }
        }
        this.query.addQueryListener(new QueryListener(){

            public void updateState(QueryState state) {
                logger.debug("Query state changed: {}", (Object)state);
                QuerySeriesData.this.handleUpdate();
            }

            public void updateParameters(QueryParameters parameters, Set<String> valueTypes) {
                QuerySeriesData.this.handleUpdate();
            }

            public void updateData(int index, Map<String, List<Double>> values, List<ValueInformation> valueInformation) {
                QuerySeriesData.this.handleUpdate();
            }
        });
    }

    public ServiceQueryBuffer getQuery() {
        return this.query;
    }

    protected void handleUpdate() {
        this.checkRequest();
        if (this.query.getQueryParameters() == null) {
            logger.debug("No query parameters. No update call");
            return;
        }
        this.fireUpdateListener(this.query.getQueryParameters().getStartTimestamp(), this.query.getQueryParameters().getEndTimestamp());
    }

    private QueryParameters makeInitialParameters() {
        return new QueryParameters(this.getXAxis().getMin(), this.getXAxis().getMax(), 25);
    }

    private ConnectionRequest createRequest() {
        return new ConnectionRequest(null, ConnectionInformation.fromURI((String)this.item.getConnectionString()), null, false);
    }

    public void setRequestWindow(long startTimestamp, long endTimestamp) {
        logger.info("Setting request window - start: {}, end: {}", (Object)startTimestamp, (Object)endTimestamp);
        this.changeParameters(new QueryParameters(startTimestamp, endTimestamp, this.parameters.getNumberOfEntries()));
    }

    private void checkRequest() {
        if (this.nextParameters != null) {
            this.changeParameters(this.nextParameters);
        }
    }

    private void changeParameters(QueryParameters parameters) {
        if (parameters == null) {
            return;
        }
        this.parameters = parameters;
        if (this.query.getState() == QueryState.COMPLETE) {
            this.nextParameters = null;
            logger.info("Change request parameters - parameters: {}, item: {}", (Object)parameters, (Object)this.item);
            this.query.changeProperties(this.parameters);
        } else {
            this.nextParameters = parameters;
        }
    }

    public void setRequestWidth(int width) {
        this.changeParameters(new QueryParameters(this.parameters.getStartTimestamp(), this.parameters.getEndTimestamp(), Math.max(0, width)));
    }

    public SeriesViewData getViewData(String type) {
        WritableSeriesData data = new WritableSeriesData();
        if (this.query.getState() == QueryState.DISCONNECTED) {
            return data;
        }
        Map values = this.query.getValues();
        if (values == null) {
            return data;
        }
        List rawData = (List)this.query.getValues().get(type);
        if (rawData == null) {
            return data;
        }
        List info = this.query.getValueInformation();
        if (info == null || info.size() != rawData.size()) {
            return data;
        }
        int i = 0;
        while (i < info.size()) {
            if (info.get(i) != null) {
                long timestamp = ((ValueInformation)info.get(i)).getStartTimestamp();
                if (rawData.get(i) != null) {
                    Double value = (Double)rawData.get(i);
                    data.add(new DataEntry(timestamp, value));
                } else {
                    data.add(new DataEntry(timestamp, null));
                }
            }
            ++i;
        }
        return data;
    }

    public SeriesViewData getQualityData() {
        WritableSeriesData data = new WritableSeriesData();
        if (this.query.getState() == QueryState.DISCONNECTED) {
            return data;
        }
        Map values = this.query.getValues();
        if (values == null) {
            return data;
        }
        List rawData = this.query.getValueInformation();
        if (rawData == null) {
            return data;
        }
        List info = this.query.getValueInformation();
        if (info == null || info.size() != rawData.size()) {
            return data;
        }
        int i = 0;
        while (i < info.size()) {
            if (info.get(i) != null) {
                long timestamp = ((ValueInformation)info.get(i)).getStartTimestamp();
                if (rawData.get(i) != null) {
                    Double value = ((ValueInformation)rawData.get(i)).getQuality();
                    data.add(new DataEntry(timestamp, value));
                } else {
                    data.add(new DataEntry(timestamp, null));
                }
            }
            ++i;
        }
        return data;
    }

    public SeriesViewData getViewData() {
        return this.getViewData("AVG");
    }

    public void dispose() {
        this.query.close();
        super.dispose();
    }

    public void open() {
        this.query.open();
    }

    public void close() {
        this.query.close();
    }
}

