/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.input.composite;

import java.util.Collection;
import java.util.NavigableSet;
import org.eclipse.scada.chart.DataEntry;
import org.eclipse.scada.chart.SeriesViewData;
import org.eclipse.scada.chart.WritableSeriesData;
import org.eclipse.scada.ui.chart.viewer.input.composite.CompositeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.profiler.Profiler;

public class MergeQualityData {
    private static final Logger logger = LoggerFactory.getLogger(MergeQualityData.class);
    private final Collection<CompositeSource> sources;
    private WritableSeriesData data;
    private final long startTimestamp;
    private final long endTimestamp;
    private final int width;

    public MergeQualityData(Collection<CompositeSource> sources, long startTimestamp, long endTimestamp, int width) {
        this.sources = sources;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.width = width;
    }

    public void merge() {
        block11: {
            boolean tooLong;
            this.data = new WritableSeriesData();
            if (this.width <= 0 || this.startTimestamp >= this.endTimestamp) {
                logger.debug("Skip merge - width: {}, start: {}, end: {}", new Object[]{this.width, this.startTimestamp, this.endTimestamp});
                return;
            }
            Profiler p = new Profiler("Merge");
            p.setLogger(logger);
            long start = System.currentTimeMillis();
            try {
                try {
                    p.start("Init");
                    Entry[] data = new Entry[this.width];
                    long diff = this.endTimestamp - this.startTimestamp;
                    double step = (double)diff / (double)this.width;
                    double c = 0.0;
                    int i = 0;
                    while (i < data.length) {
                        data[i] = new Entry();
                        data[i].timestamp = this.startTimestamp + (long)c;
                        c += step;
                        ++i;
                    }
                    p.start("Perform merge");
                    this.performMerge(data, step);
                    p.start("Convert");
                    Entry[] entryArray = data;
                    int n = data.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Entry entry = entryArray[n2];
                        this.data.add(new DataEntry(entry.timestamp, entry.value));
                        ++n2;
                    }
                }
                catch (Exception e) {
                    boolean tooLong2;
                    logger.warn("Failed to merge data", (Throwable)e);
                    p.stop();
                    boolean bl = tooLong2 = System.currentTimeMillis() - start > 10000L;
                    if (tooLong2 || logger.isTraceEnabled()) {
                        p.log();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                boolean tooLong3;
                p.stop();
                boolean bl = tooLong3 = System.currentTimeMillis() - start > 10000L;
                if (tooLong3 || logger.isTraceEnabled()) {
                    p.log();
                }
                throw throwable;
            }
            p.stop();
            boolean bl = tooLong = System.currentTimeMillis() - start > 10000L;
            if (tooLong || logger.isTraceEnabled()) {
                p.log();
            }
        }
    }

    private void performMerge(Entry[] data, double step) {
        logger.debug("Running merge for {} sources", (Object)this.sources.size());
        for (CompositeSource source : this.sources) {
            SeriesViewData viewData = source.getViewData();
            if (viewData == null) {
                logger.trace("No view data");
                continue;
            }
            NavigableSet entries = viewData.getEntries();
            if (entries == null) {
                logger.trace("No entries");
                continue;
            }
            for (DataEntry entry : entries) {
                if (entry.getTimestamp() < this.startTimestamp || entry.getTimestamp() >= this.endTimestamp) continue;
                int idx = (int)Math.ceil((double)(entry.getTimestamp() - this.startTimestamp) / step);
                logger.trace("ts: {}, start: {}, step: {} => {}", new Object[]{entry.getTimestamp(), this.startTimestamp, step, (double)(entry.getTimestamp() - this.startTimestamp) / step});
                double q = entry.getValue() == null ? 0.0 : entry.getValue();
                logger.trace("merged quality [{}]: {}", (Object)idx, (Object)q);
                data[idx].value = data[idx].value == null ? Double.valueOf(q) : Double.valueOf(Math.min(data[idx].value, q));
            }
        }
    }

    public WritableSeriesData getData() {
        return this.data;
    }

    private static class Entry {
        public Double value;
        public long timestamp;

        private Entry() {
        }
    }
}

