/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.dataitem.details.extra.part;

import java.util.HashMap;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.CheckBox;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.dataitem.details.extra.part.AbstractBaseDraw2DDetailsPart;
import org.eclipse.scada.da.client.dataitem.details.extra.part.Messages;
import org.eclipse.scada.da.client.dataitem.details.extra.part.VariantEntryDialog;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.ui.DisplayCallbackHandler;

public class InputScaleDetails
extends AbstractBaseDraw2DDetailsPart {
    private RoundedRectangle factorFigure;
    private RoundedRectangle rawFigure;
    private RoundedRectangle valueFigure;
    private Label factorLabel;
    private Label valueLabel;
    private Label rawLabel;
    private RoundedRectangle offsetFigure;
    private Label offsetLabel;
    private CheckBox button;

    @Override
    protected IFigure createMain() {
        Figure rootFigure = new Figure();
        rootFigure.setLayoutManager((LayoutManager)new GridLayout(4, true));
        rootFigure.setBackgroundColor(ColorConstants.white);
        rootFigure.add((IFigure)this.makeHeader(), (Object)new GridData(1, 2, true, false, 4, 1));
        rootFigure.add((IFigure)new Figure());
        this.factorFigure = new RoundedRectangle();
        rootFigure.add((IFigure)this.factorFigure, (Object)new GridData(2, 2, true, true));
        this.factorFigure.setAntialias(1);
        this.factorFigure.setBackgroundColor(ColorConstants.lightGray);
        this.factorFigure.setForegroundColor(ColorConstants.black);
        this.factorFigure.setBorder((Border)new MarginBorder(10));
        this.factorFigure.setLayoutManager((LayoutManager)new BorderLayout());
        this.factorLabel = new Label();
        this.factorFigure.add((IFigure)this.factorLabel, (Object)BorderLayout.CENTER);
        this.factorFigure.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseEntered(MouseEvent me) {
                InputScaleDetails.this.factorFigure.setLineWidth(2);
            }

            public void mouseExited(MouseEvent me) {
                InputScaleDetails.this.factorFigure.setLineWidth(1);
            }
        });
        this.offsetFigure = new RoundedRectangle();
        rootFigure.add((IFigure)this.offsetFigure, (Object)new GridData(2, 2, true, true));
        this.offsetFigure.setAntialias(1);
        this.offsetFigure.setBackgroundColor(ColorConstants.lightGray);
        this.offsetFigure.setForegroundColor(ColorConstants.black);
        this.offsetFigure.setBorder((Border)new MarginBorder(10));
        this.offsetFigure.setLayoutManager((LayoutManager)new BorderLayout());
        this.offsetLabel = new Label();
        this.offsetFigure.add((IFigure)this.offsetLabel, (Object)BorderLayout.CENTER);
        this.offsetFigure.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseEntered(MouseEvent me) {
                InputScaleDetails.this.offsetFigure.setLineWidth(2);
            }

            public void mouseExited(MouseEvent me) {
                InputScaleDetails.this.offsetFigure.setLineWidth(1);
            }
        });
        rootFigure.add((IFigure)new Figure());
        this.rawFigure = new RoundedRectangle();
        rootFigure.add((IFigure)this.rawFigure, (Object)new GridData(2, 2, true, true));
        this.rawFigure.setAntialias(1);
        this.rawFigure.setBackgroundColor(ColorConstants.lightGray);
        this.rawFigure.setForegroundColor(ColorConstants.black);
        this.rawFigure.setBorder((Border)new MarginBorder(10));
        this.rawFigure.setLayoutManager((LayoutManager)new BorderLayout());
        this.rawLabel = new Label();
        this.rawFigure.add((IFigure)this.rawLabel, (Object)BorderLayout.CENTER);
        RectangleFigure factorRect = new RectangleFigure();
        factorRect.setLayoutManager((LayoutManager)new BorderLayout());
        factorRect.add((IFigure)new Label(Messages.InputScaleDetails_Multiply), (Object)BorderLayout.CENTER);
        factorRect.setBorder((Border)new MarginBorder(10));
        factorRect.setBackgroundColor(ColorConstants.lightGray);
        factorRect.setForegroundColor(ColorConstants.black);
        factorRect.setLineStyle(1);
        factorRect.setLineWidth(1);
        factorRect.setFill(true);
        factorRect.setOpaque(true);
        rootFigure.add((IFigure)factorRect, (Object)new GridData(2, 2, true, true));
        RectangleFigure offsetRect = new RectangleFigure();
        offsetRect.setLayoutManager((LayoutManager)new BorderLayout());
        offsetRect.add((IFigure)new Label(Messages.InputScaleDetails_Add), (Object)BorderLayout.CENTER);
        offsetRect.setBorder((Border)new MarginBorder(10));
        offsetRect.setBackgroundColor(ColorConstants.lightGray);
        offsetRect.setForegroundColor(ColorConstants.black);
        offsetRect.setLineStyle(1);
        offsetRect.setLineWidth(1);
        offsetRect.setFill(true);
        offsetRect.setOpaque(true);
        rootFigure.add((IFigure)offsetRect, (Object)new GridData(2, 2, true, true));
        this.valueFigure = new RoundedRectangle();
        rootFigure.add((IFigure)this.valueFigure, (Object)new GridData(2, 2, true, true));
        this.valueFigure.setAntialias(1);
        this.valueFigure.setLayoutManager((LayoutManager)new BorderLayout());
        this.valueFigure.setBackgroundColor(ColorConstants.lightGray);
        this.valueFigure.setForegroundColor(ColorConstants.black);
        this.valueFigure.setBorder((Border)new MarginBorder(10));
        this.valueLabel = new Label();
        this.valueFigure.add((IFigure)this.valueLabel, (Object)BorderLayout.CENTER);
        this.connect((IFigure)rootFigure, (IFigure)this.factorFigure, (IFigure)factorRect);
        this.connect((IFigure)rootFigure, (IFigure)this.rawFigure, (IFigure)factorRect);
        this.connect((IFigure)rootFigure, (IFigure)factorRect, (IFigure)offsetRect);
        this.connect((IFigure)rootFigure, (IFigure)this.offsetFigure, (IFigure)offsetRect);
        this.connect((IFigure)rootFigure, (IFigure)offsetRect, (IFigure)this.valueFigure);
        this.factorFigure.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mouseDoubleClicked(MouseEvent me) {
                InputScaleDetails.this.triggerFactorInput();
            }
        });
        this.offsetFigure.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mouseDoubleClicked(MouseEvent me) {
                InputScaleDetails.this.triggerOffsetInput();
            }
        });
        return rootFigure;
    }

    private Figure makeHeader() {
        this.button = new CheckBox("Active");
        this.button.getModel().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                InputScaleDetails.this.setEnabled(InputScaleDetails.this.button.getModel().isSelected());
            }
        });
        return this.button;
    }

    protected void setEnabled(boolean selected) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(1);
        attributes.put("org.eclipse.scada.da.scale.input.active", Variant.valueOf((boolean)selected));
        this.item.writeAtrtibutes(attributes, null, (CallbackHandler)this.makeDisplayCallback());
    }

    private DisplayCallbackHandler makeDisplayCallback() {
        return new DisplayCallbackHandler(this.shell, "Configure", "Confirmation required for configuration of input scale");
    }

    protected void triggerFactorInput() {
        Variant factor = new VariantEntryDialog(this.shell).getValue();
        if (factor != null) {
            HashMap<String, Variant> attributes = new HashMap<String, Variant>(1);
            attributes.put("org.eclipse.scada.da.scale.input.factor", factor);
            this.item.writeAtrtibutes(attributes, null, (CallbackHandler)this.makeDisplayCallback());
        }
    }

    protected void triggerOffsetInput() {
        Variant factor = new VariantEntryDialog(this.shell).getValue();
        if (factor != null) {
            HashMap<String, Variant> attributes = new HashMap<String, Variant>(1);
            attributes.put("org.eclipse.scada.da.scale.input.offset", factor);
            this.item.writeAtrtibutes(attributes, null, (CallbackHandler)this.makeDisplayCallback());
        }
    }

    private void connect(IFigure figure, IFigure source, IFigure target) {
        PolylineConnection c = new PolylineConnection();
        c.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor(source));
        c.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor(target));
        PolygonDecoration dec = new PolygonDecoration();
        dec.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        dec.setBackgroundColor(ColorConstants.black);
        c.setTargetDecoration((RotatableDecoration)dec);
        figure.add((IFigure)c);
    }

    @Override
    protected void update() {
        super.update();
        if (this.value == null) {
            return;
        }
        this.valueLabel.setText(this.value.getValue().toString());
        Variant factor = (Variant)this.value.getAttributes().get("org.eclipse.scada.da.scale.input.factor");
        Variant raw = (Variant)this.value.getAttributes().get("org.eclipse.scada.da.scale.input.value.original");
        Variant active = (Variant)this.value.getAttributes().get("org.eclipse.scada.da.scale.input.active");
        Variant offset = (Variant)this.value.getAttributes().get("org.eclipse.scada.da.scale.input.offset");
        if (active != null && active.asBoolean()) {
            this.button.getModel().setSelected(true);
        } else {
            this.button.getModel().setSelected(false);
        }
        if (factor != null) {
            this.factorLabel.setText(factor.toString());
        } else {
            this.factorLabel.setText("");
        }
        if (raw != null) {
            this.rawLabel.setText(raw.toString());
        } else {
            this.rawLabel.setText("");
        }
        if (offset != null) {
            this.offsetLabel.setText(offset.toString());
        } else {
            this.offsetLabel.setText("");
        }
    }

    @Override
    protected boolean isAvailable() {
        return this.hasAttribute("org.eclipse.scada.da.scale.input.active");
    }
}

