/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.scada.core.ui.connection.login.LoginSession;
import org.eclipse.scada.core.ui.connection.login.SessionListener;
import org.eclipse.scada.core.ui.connection.login.SessionManager;
import org.eclipse.scada.vi.details.DetailView;
import org.eclipse.scada.vi.details.DetailViewManager;
import org.eclipse.scada.vi.details.Messages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailViewDialog
implements SessionListener {
    private static final Logger logger = LoggerFactory.getLogger(DetailViewDialog.class);
    private static final String detailRole = System.getProperty("org.eclipse.scada.vi.details.roles.detailView", "operator");
    private static final String debugInformationRole = System.getProperty("org.eclipse.scada.vi.details.roles.debugInformation", "developer");
    private Shell shell;
    private final Shell parentShell;
    private final Map<String, String> properties;
    private final String id;
    private DetailView detailView;
    private LoginSession session;

    public DetailViewDialog(Shell parentShell, String id, Map<String, String> properties) {
        this.parentShell = parentShell;
        this.id = id;
        this.properties = new HashMap<String, String>(properties);
        this.session = SessionManager.getDefault().getSession();
    }

    public void open() {
        try {
            if (this.session == null || !this.session.hasRole(detailRole)) {
                ErrorDialog.openError((Shell)this.parentShell, (String)Messages.DetailViewDialog_ErrorDialog_Title, (String)Messages.DetailViewDialog_ErrorDialog_NoSession, (IStatus)new Status(4, "org.eclipse.scada.vi.details", String.format(Messages.DetailViewDialog_ErrorMessage_NoSession, this.id)));
                return;
            }
            this.detailView = DetailViewManager.openView(this.id, this.properties);
            if (this.detailView == null) {
                ErrorDialog.openError((Shell)this.parentShell, (String)Messages.DetailViewDialog_ErrorDialog_Title, (String)Messages.DetailViewDialog_ErrorDialog_Message_NotFound, (IStatus)new Status(4, "org.eclipse.scada.vi.details", String.format(Messages.DetailViewDialog_ErrorMessage_NotFound, this.id)));
                return;
            }
        }
        catch (CoreException e) {
            logger.warn("Failed to load view", (Throwable)e);
            ErrorDialog.openError((Shell)this.parentShell, (String)Messages.DetailViewDialog_ErrorDialog_Title, (String)Messages.DetailViewDialog_ExceptionDialog_Message, (IStatus)e.getStatus());
            return;
        }
        this.shell = new Shell(this.parentShell, 2160);
        this.shell.setMinimumSize(400, 100);
        this.shell.setText(this.makeTitle());
        this.shell.setToolTipText("");
        if (this.session.hasRole(debugInformationRole)) {
            for (String key : this.properties.keySet()) {
                this.shell.setToolTipText(String.valueOf(this.shell.getToolTipText()) + this.properties.get(key) + "\n");
            }
        }
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                DetailViewDialog.this.dispose();
            }
        });
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                DetailViewDialog.this.dispose();
            }
        });
        this.detailView.init((Composite)this.shell, this.properties);
        this.shell.pack();
        this.shell.open();
        SessionManager.getDefault().addListener((SessionListener)this);
    }

    protected String makeTitle() {
        String title = this.properties.get("title");
        if (title != null) {
            return title;
        }
        String linkName = this.properties.get("linkName");
        String linkDetailView = this.properties.get("linkDetailView");
        if (linkName != null && linkDetailView != null) {
            return String.format("%s | %s", linkName, linkDetailView);
        }
        return "Detail View";
    }

    public void dispose() {
        SessionManager.getDefault().removeListener((SessionListener)this);
        if (this.detailView != null) {
            this.detailView.dispose();
        }
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    public void sessionChanged(LoginSession session) {
        this.session = session;
        if (session != null && session.hasRole(detailRole)) {
            return;
        }
        if (this.session == null) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DetailViewDialog.this.dispose();
                }
            });
        }
    }
}

