/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.config;

import java.util.Collections;
import java.util.List;
import org.eclipse.scada.ae.ui.views.config.ConnectionType;
import org.eclipse.scada.ae.ui.views.config.Messages;
import org.eclipse.scada.ae.ui.views.views.ColumnProperties;
import org.eclipse.scada.utils.lang.Immutable;

@Immutable
public class MonitorViewConfiguration {
    private final String id;
    private final String label;
    private final String monitorQueryId;
    private final String connectionString;
    private final ConnectionType connectionType;
    private final List<ColumnProperties> columns;

    public MonitorViewConfiguration(String id, String monitorQueryId, String connectionString, ConnectionType connectionType, String label, List<ColumnProperties> columns) {
        this.id = id;
        this.monitorQueryId = monitorQueryId;
        this.connectionString = connectionString;
        this.connectionType = connectionType;
        this.label = label;
        this.columns = columns;
        if (this.id == null) {
            throw new IllegalArgumentException(Messages.MonitorViewConfiguration_IllegalArgument_id);
        }
        if (this.monitorQueryId == null) {
            throw new IllegalArgumentException(Messages.MonitorViewConfiguration_IllegalArgument_monitorQueryId);
        }
        if (this.connectionString == null) {
            throw new IllegalArgumentException(Messages.MonitorViewConfiguration_IllegalArgument_connectionString);
        }
        if (this.connectionType == null) {
            throw new IllegalArgumentException(Messages.MonitorViewConfiguration_IllegalArgument_connectionType);
        }
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public String getMonitorQueryId() {
        return this.monitorQueryId;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public List<ColumnProperties> getColumns() {
        return Collections.unmodifiableList(this.columns == null ? Collections.EMPTY_LIST : this.columns);
    }
}

