/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.dialog;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.ae.ui.views.Messages;
import org.eclipse.scada.ae.ui.views.dialog.FilterChangedListener;
import org.eclipse.scada.ae.ui.views.dialog.SearchType;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.scada.utils.filter.Assertion;
import org.eclipse.scada.utils.filter.Filter;
import org.eclipse.scada.utils.filter.FilterAssertion;
import org.eclipse.scada.utils.filter.FilterExpression;
import org.eclipse.scada.utils.filter.FilterParser;
import org.eclipse.scada.utils.filter.Operator;
import org.eclipse.scada.utils.lang.Pair;
import org.eclipse.scada.utils.propertyeditors.DateEditor;
import org.eclipse.scada.utils.str.StringHelper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;

public class FilterQueryByExampleComposite
extends Composite {
    final Button clearButton;
    private final Map<String, FieldEntry> fields = new HashMap<String, FieldEntry>();

    public FilterQueryByExampleComposite(final FilterChangedListener filterChangedListener, Composite parent, int style, String filter) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.numColumns = 6;
        layout.marginHeight = 12;
        layout.marginWidth = 12;
        this.setLayout((Layout)layout);
        FilterModified filterModified = new FilterModified(){

            @Override
            public void onModified() {
                String filterString = FilterQueryByExampleComposite.this.toFilter().toString();
                filterChangedListener.onFilterChanged((Pair<SearchType, String>)new Pair((Object)SearchType.SIMPLE, (Object)filterString));
            }
        };
        this.fields.put("sourceTimestamp", new DateFieldEntry(this, "sourceTimestamp", Messages.sourceTimestamp, filterModified));
        this.fields.put("entryTimestamp", new DateFieldEntry(this, "entryTimestamp", Messages.entryTimestamp, filterModified));
        this.fields.put("message", new TextFieldEntry(this, "message", Messages.message, filterModified));
        this.fields.put("monitorType", new TextFieldEntry(this, "monitorType", Messages.monitorType, filterModified));
        this.fields.put("eventType", new TextFieldEntry(this, "eventType", Messages.eventType, filterModified));
        this.fields.put("item", new TextFieldEntry(this, "item", Messages.item, filterModified));
        this.fields.put("value", new TextFieldEntry(this, "value", Messages.value, filterModified));
        this.fields.put("priority", new TextFieldEntry(this, "priority", Messages.priority, filterModified));
        this.fields.put("source", new TextFieldEntry(this, "source", Messages.source, filterModified));
        this.fields.put("actorType", new TextFieldEntry(this, "actorType", Messages.actorType, filterModified));
        this.fields.put("actorName", new TextFieldEntry(this, "actorName", Messages.actorName, filterModified));
        this.fields.put("component", new TextFieldEntry(this, "component", Messages.component, filterModified));
        this.fields.put("system", new TextFieldEntry(this, "system", Messages.system, filterModified));
        this.fields.put("hive", new TextFieldEntry(this, "hive", Messages.hive, filterModified));
        this.fields.put("location", new TextFieldEntry(this, "location", Messages.location, filterModified));
        this.fields.put("messageSource", new TextFieldEntry(this, "messageSource", Messages.messageSource, filterModified));
        this.fields.put("comment", new TextFieldEntry(this, "comment", Messages.comment, filterModified));
        this.clearButton = new Button((Composite)this, 8);
        this.clearButton.setText(Messages.clear);
        GridData clearButtonLayoutData = new GridData();
        clearButtonLayoutData.horizontalAlignment = 1;
        clearButtonLayoutData.horizontalSpan = 6;
        this.clearButton.setLayoutData((Object)clearButtonLayoutData);
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (FieldEntry fieldEntry : FilterQueryByExampleComposite.this.fields.values()) {
                    fieldEntry.clear();
                }
                ((FieldEntry)FilterQueryByExampleComposite.this.fields.get("sourceTimestamp")).focus();
            }
        });
        this.populateFromFilter(filter);
        this.fields.get("sourceTimestamp").focus();
    }

    public static int needBorder() {
        return 2048;
    }

    private void populateFromFilter(String filterString) {
        Filter filter;
        if (filterString == null || filterString.length() == 0) {
            return;
        }
        try {
            filter = new FilterParser(filterString).getFilter();
        }
        catch (Exception e) {
            StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.ae.ui.views", (Throwable)e), 1);
            return;
        }
        if (!filter.isExpression()) {
            return;
        }
        FilterExpression filterExpression = (FilterExpression)filter;
        if (filterExpression.getOperator() != Operator.AND) {
            return;
        }
        for (Filter subFilter : filterExpression.getFilterSet()) {
            FilterAssertion filterAssertion;
            if (subFilter.isAssertion()) {
                this.populateFromAssertion(false, (FilterAssertion)subFilter);
                continue;
            }
            if (!subFilter.isExpression()) continue;
            FilterExpression subFilterExpression = (FilterExpression)subFilter;
            if (subFilterExpression.getOperator() == Operator.NOT) {
                if (subFilterExpression.getFilterSet().size() != 1 || !((Filter)subFilterExpression.getFilterSet().get(0)).isAssertion()) continue;
                this.populateFromAssertion(true, (FilterAssertion)subFilterExpression.getFilterSet().get(0));
                continue;
            }
            if (subFilterExpression.getOperator() != Operator.AND) continue;
            String attribute = null;
            String from = null;
            String to = null;
            if (subFilterExpression.getFilterSet().size() == 1 || subFilterExpression.getFilterSet().size() == 2 && ((Filter)subFilterExpression.getFilterSet().get(0)).isAssertion()) {
                filterAssertion = (FilterAssertion)subFilterExpression.getFilterSet().get(0);
                attribute = filterAssertion.getAttribute();
                if (filterAssertion != null && filterAssertion.getAssertion() == Assertion.GREATEREQ) {
                    from = (String)filterAssertion.getValue();
                } else if (filterAssertion != null && filterAssertion.getAssertion() == Assertion.LESSEQ) {
                    to = (String)filterAssertion.getValue();
                }
            }
            if (subFilterExpression.getFilterSet().size() == 2 && ((Filter)subFilterExpression.getFilterSet().get(1)).isAssertion()) {
                filterAssertion = (FilterAssertion)subFilterExpression.getFilterSet().get(1);
                if (filterAssertion != null && filterAssertion.getAssertion() == Assertion.GREATEREQ) {
                    from = (String)filterAssertion.getValue();
                } else if (filterAssertion != null && filterAssertion.getAssertion() == Assertion.LESSEQ) {
                    to = (String)filterAssertion.getValue();
                }
            }
            this.populateFromDate(attribute, from, to);
        }
    }

    private void populateFromAssertion(boolean negate, FilterAssertion filter) {
        FieldEntry fieldEntry = this.fields.get(filter.getAttribute());
        if (fieldEntry instanceof TextFieldEntry) {
            VariantEditor ve = new VariantEditor();
            if (filter.getValue() instanceof String) {
                ve.setAsText((String)filter.getValue());
            } else if (filter.getValue() instanceof Collection) {
                ve.setAsText(StringHelper.join((Collection)((Collection)filter.getValue()), (String)"*"));
            }
            Variant value = (Variant)ve.getValue();
            ((TextFieldEntry)fieldEntry).setValue(value.toLabel(""));
            ((TextFieldEntry)fieldEntry).setNegation(negate);
        }
    }

    private void populateFromDate(String fieldName, String from, String to) {
        FieldEntry fieldEntry = this.fields.get(fieldName);
        if (fieldEntry instanceof DateFieldEntry) {
            DateEditor dateEditor = new DateEditor();
            DateFieldEntry dateFieldEntry = (DateFieldEntry)fieldEntry;
            dateEditor.setAsText(from);
            dateFieldEntry.setFrom((Date)dateEditor.getValue());
            dateEditor.setAsText(to);
            dateFieldEntry.setTo((Date)dateEditor.getValue());
        }
    }

    private Filter toFilter() {
        FilterExpression filter = new FilterExpression();
        filter.setOperator(Operator.AND);
        for (FieldEntry fieldEntry : this.fields.values()) {
            if (fieldEntry.isEmpty()) continue;
            filter.getFilterSet().add(fieldEntry.asExpression());
        }
        return filter;
    }

    private static Collection<String> toCollection(String text) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(text.split("\\*")));
        if (text.endsWith("*")) {
            result.add("");
        }
        return result;
    }

    private static class DateFieldEntry
    implements FieldEntry {
        private final String field;
        private final Label captionLabel;
        private final Label fromLabel;
        private final Label toLabel;
        private final DateTime fromDate;
        private final DateTime fromTime;
        private final DateTime toDate;
        private final DateTime toTime;
        private final Button useCheckbox;
        private final FilterModified filterModified;
        private static final DateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

        public DateFieldEntry(Composite parent, String field, String caption, final FilterModified filterModified) {
            GridData dateLayoutData = new GridData();
            dateLayoutData.widthHint = 180;
            this.field = field;
            this.captionLabel = new Label(parent, 0);
            this.captionLabel.setText(caption);
            this.filterModified = filterModified;
            this.useCheckbox = new Button(parent, 32);
            this.useCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DateFieldEntry.this.updateFromCheckbox();
                    filterModified.onModified();
                }
            });
            this.fromLabel = new Label(parent, 0);
            this.fromLabel.setText(Messages.from);
            SelectionAdapter updater = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    filterModified.onModified();
                }
            };
            Composite wrapper = new Composite(parent, 0);
            wrapper.setLayout((Layout)new GridLayout(2, false));
            this.fromDate = new DateTime(wrapper, 0x20 | FilterQueryByExampleComposite.needBorder());
            this.fromTime = new DateTime(wrapper, 0x80 | FilterQueryByExampleComposite.needBorder());
            this.fromDate.addSelectionListener((SelectionListener)updater);
            this.fromTime.addSelectionListener((SelectionListener)updater);
            this.toLabel = new Label(parent, 0);
            this.toLabel.setText(Messages.to);
            wrapper = new Composite(parent, 0);
            wrapper.setLayout((Layout)new GridLayout(2, false));
            this.toDate = new DateTime(wrapper, 0x20 | FilterQueryByExampleComposite.needBorder());
            this.toTime = new DateTime(wrapper, 0x80 | FilterQueryByExampleComposite.needBorder());
            this.toDate.addSelectionListener((SelectionListener)updater);
            this.toTime.addSelectionListener((SelectionListener)updater);
            this.updateFromCheckbox();
        }

        protected void updateFromCheckbox() {
            boolean enabled = this.useCheckbox.getSelection();
            this.fromDate.setEnabled(enabled);
            this.fromTime.setEnabled(enabled);
            this.toDate.setEnabled(enabled);
            this.toTime.setEnabled(enabled);
        }

        @Override
        public Filter asExpression() {
            FilterAssertion assertionFrom = null;
            FilterAssertion assertionTo = null;
            FilterExpression expression = new FilterExpression();
            expression.setOperator(Operator.AND);
            if (this.useCheckbox.getSelection()) {
                GregorianCalendar from = new GregorianCalendar();
                from.set(this.fromDate.getYear(), this.fromDate.getMonth(), this.fromDate.getDay(), this.fromTime.getHours(), this.fromTime.getMinutes(), this.fromTime.getSeconds());
                assertionFrom = new FilterAssertion(this.field, Assertion.GREATEREQ, (Object)isoDateFormat.format(from.getTime()));
                expression.getFilterSet().add(assertionFrom);
                GregorianCalendar to = new GregorianCalendar();
                to.set(this.toDate.getYear(), this.toDate.getMonth(), this.toDate.getDay(), this.toTime.getHours(), this.toTime.getMinutes(), this.toTime.getSeconds());
                assertionTo = new FilterAssertion(this.field, Assertion.LESSEQ, (Object)isoDateFormat.format(to.getTime()));
                expression.getFilterSet().add(assertionTo);
            }
            return expression;
        }

        @Override
        public boolean isEmpty() {
            return !this.useCheckbox.getSelection();
        }

        @Override
        public void clear() {
            this.useCheckbox.setSelection(false);
            this.updateFromCheckbox();
            this.filterModified.onModified();
        }

        @Override
        public void focus() {
            this.fromDate.setFocus();
        }

        public void setFrom(Date date) {
            this.useCheckbox.setSelection(true);
            this.updateFromCheckbox();
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(date);
            this.fromDate.setDate(c.get(1), c.get(2), c.get(5));
            this.fromTime.setTime(c.get(11), c.get(12), c.get(13));
        }

        public void setTo(Date date) {
            this.useCheckbox.setSelection(true);
            this.updateFromCheckbox();
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(date);
            this.toDate.setDate(c.get(1), c.get(2), c.get(5));
            this.toTime.setTime(c.get(11), c.get(12), c.get(13));
        }
    }

    private static interface FieldEntry {
        public Filter asExpression();

        public boolean isEmpty();

        public void clear();

        public void focus();
    }

    private static interface FilterModified {
        public void onModified();
    }

    private static class TextFieldEntry
    implements FieldEntry {
        protected final String field;
        protected final Label captionLabel;
        protected final Button notCheckBox;
        protected final Text textText;

        public TextFieldEntry(Composite parent, String field, String caption, final FilterModified filterModified) {
            this.field = field;
            this.captionLabel = new Label(parent, 0);
            this.captionLabel.setText(caption);
            this.notCheckBox = new Button(parent, 32);
            this.notCheckBox.setText(Messages.not);
            this.notCheckBox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    filterModified.onModified();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.textText = new Text(parent, 2048);
            GridData layoutData = new GridData();
            layoutData.horizontalAlignment = 4;
            layoutData.horizontalSpan = 4;
            layoutData.grabExcessHorizontalSpace = true;
            this.textText.setLayoutData((Object)layoutData);
            this.textText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    filterModified.onModified();
                }
            });
            this.textText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    filterModified.onModified();
                }
            });
        }

        @Override
        public Filter asExpression() {
            FilterAssertion assertion = this.textText.getText().contains("*") ? new FilterAssertion(this.field, Assertion.SUBSTRING, (Object)FilterQueryByExampleComposite.toCollection(this.textText.getText())) : new FilterAssertion(this.field, Assertion.EQUALITY, (Object)this.textText.getText());
            if (this.notCheckBox.getSelection()) {
                return FilterExpression.negate((Filter)assertion);
            }
            return assertion;
        }

        @Override
        public boolean isEmpty() {
            return this.textText.getText().trim().length() == 0;
        }

        @Override
        public void clear() {
            this.textText.setText("");
        }

        @Override
        public void focus() {
            this.textText.setFocus();
        }

        public void setValue(String value) {
            this.textText.setText(value);
        }

        public void setNegation(boolean negate) {
            this.notCheckBox.setSelection(negate);
        }
    }
}

