/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.model;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.data.MonitorStatus;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.ui.views.handler.AckInformation;
import org.eclipse.scada.ae.ui.views.model.MonitorData;
import org.eclipse.scada.utils.beans.AbstractPropertyChange;

public class DecoratedEvent
extends AbstractPropertyChange
implements Serializable,
IAdaptable,
Comparable<DecoratedEvent> {
    private static final long serialVersionUID = -565152685009234585L;
    public static final DecoratedEventComparator comparator = new DecoratedEventComparator();
    private Event event;
    private MonitorData monitor;

    public MonitorStatusInformation getMonitor() {
        return this.monitor;
    }

    public void setMonitor(MonitorData monitor) {
        this.monitor = monitor;
        this.firePropertyChange("monitor", (Object)this.monitor, (Object)this.monitor);
    }

    public DecoratedEvent(Event event) {
        this.event = event;
    }

    public DecoratedEvent(Event event, MonitorData monitor) {
        this.event = event;
        this.monitor = monitor;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
        this.firePropertyChange("event", this.event, this.event);
    }

    public String toString() {
        return String.valueOf(this.event);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DecoratedEvent other = (DecoratedEvent)obj;
        return !(this.event == null ? other.event != null : !this.event.equals((Object)other.event));
    }

    public boolean isActive() {
        if (this.event == null) {
            return false;
        }
        if (this.monitor == null) {
            return false;
        }
        return this.event.getSourceTimestamp().compareTo(new Date(this.monitor.getStatusTimestamp())) >= 0;
    }

    public boolean isAlarm() {
        return this.isActive() && (this.monitor.getStatus() == MonitorStatus.NOT_OK || this.monitor.getStatus() == MonitorStatus.NOT_OK_AKN || this.monitor.getStatus() == MonitorStatus.NOT_OK_NOT_AKN);
    }

    public boolean isAknRequired() {
        return this.isActive() && (this.monitor.getStatus() == MonitorStatus.NOT_AKN || this.monitor.getStatus() == MonitorStatus.NOT_OK_NOT_AKN);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Event.class) {
            return this.event;
        }
        if (adapter == AckInformation.class && this.monitor != null) {
            return new AckInformation(this.monitor.getId(), this.event.getSourceTimestamp(), this.monitor.getStatus());
        }
        return null;
    }

    @Override
    public int compareTo(DecoratedEvent o) {
        return comparator.compare(this, o);
    }

    public static class DecoratedEventComparator
    implements Comparator<DecoratedEvent> {
        @Override
        public int compare(DecoratedEvent o1, DecoratedEvent o2) {
            return o1.getEvent().compareTo(o2.getEvent());
        }
    }
}

