/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.views.table;

import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scada.ae.ui.views.model.DecoratedEvent;
import org.eclipse.scada.ae.ui.views.views.LabelProviderSupport;

public class VariantLabelProvider
extends StyledCellLabelProvider {
    private final String key;
    private final LabelProviderSupport labelProviderSupport;
    private final Decoration decoration;

    public VariantLabelProvider(String key, LabelProviderSupport labelProviderSupport, Decoration decoration) {
        this.key = key;
        this.labelProviderSupport = labelProviderSupport;
        this.decoration = decoration;
    }

    public void update(ViewerCell cell) {
        DecoratedEvent event = (DecoratedEvent)cell.getElement();
        if (this.decoration != null) {
            switch (this.decoration) {
                case ACTOR: {
                    this.labelProviderSupport.decorateWithActorType(event, cell);
                    break;
                }
                case MONITOR: {
                    this.labelProviderSupport.decorateWithMonitorState(event, cell);
                }
            }
        }
        if (this.key != null && !this.key.isEmpty()) {
            cell.setText(this.labelProviderSupport.toLabel(event, this.key));
        }
    }

    public static enum Decoration {
        ACTOR,
        MONITOR;

    }
}

