/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.creator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.ui.connection.creator.Activator;
import org.eclipse.scada.core.ui.connection.creator.ConnectionCreator;

public class ConnectionCreatorHelper {
    public static ConnectionService createConnection(ConnectionInformation info, Integer autoReconnectDelay, boolean lazyActivation) {
        if (info == null) {
            return null;
        }
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.scada.core.ui.connection.creator");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionService service;
            IConfigurationElement ele = iConfigurationElementArray[n2];
            String interfaceName = ele.getAttribute("interface");
            String driverName = ele.getAttribute("driver");
            if (interfaceName != null && driverName != null && interfaceName.equals(info.getInterface()) && driverName.equals(info.getDriver()) && (service = ConnectionCreatorHelper.createConnection(info, ele, autoReconnectDelay, lazyActivation)) != null) {
                return service;
            }
            ++n2;
        }
        return null;
    }

    private static ConnectionService createConnection(ConnectionInformation connectionInformation, IConfigurationElement ele, Integer autoReconnectDelay, boolean lazyActivation) {
        Object o;
        block3: {
            try {
                o = ele.createExecutableExtension("class");
                if (o instanceof ConnectionCreator) break block3;
                return null;
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
                return null;
            }
        }
        return ((ConnectionCreator)o).createConnection(connectionInformation, autoReconnectDelay, lazyActivation);
    }
}

