/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.data;

import org.eclipse.scada.da.ui.connection.data.Item;

public class DataItemDescriptor {
    private final String connectionInformation;
    private final String itemId;
    private final String descriptor;

    public DataItemDescriptor(String connectionInformation, String itemId, String descriptor) {
        this.connectionInformation = connectionInformation;
        this.itemId = itemId;
        this.descriptor = descriptor;
    }

    public String getConnectionInformation() {
        return this.connectionInformation;
    }

    public String getItemId() {
        return this.itemId;
    }

    public static DataItemDescriptor create(String descriptor) {
        if (descriptor == null) {
            return null;
        }
        String[] toks = descriptor.split("\\#", 2);
        if (toks.length != 2) {
            return null;
        }
        return new DataItemDescriptor(toks[0], toks[1], descriptor);
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return String.valueOf(this.connectionInformation) + "#" + this.itemId;
    }

    public Item asItem() {
        return new Item(this.connectionInformation, this.itemId, Item.Type.ID);
    }
}

