/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.data;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.scada.core.connection.provider.ConnectionIdTracker;
import org.eclipse.scada.core.connection.provider.ConnectionTracker;
import org.eclipse.scada.da.client.DataItem;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.connection.provider.ConnectionService;
import org.eclipse.scada.vi.details.swt.Activator;
import org.eclipse.scada.vi.details.swt.data.DataItemDescriptor;
import org.eclipse.scada.vi.details.swt.data.ItemListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemRegistration {
    private static final Logger logger = LoggerFactory.getLogger(ItemRegistration.class);
    private final Object key;
    private final ItemListener listener;
    private final ConnectionTracker tracker;
    private DataItem item;
    private DataItemValue currentValue;
    private final DataItemDescriptor itemDescriptor;

    public ItemRegistration(Object key, DataItemDescriptor itemDescriptor, ItemListener listener) {
        this.key = key;
        this.listener = listener;
        this.itemDescriptor = itemDescriptor;
        this.tracker = new ConnectionIdTracker(Activator.getDefault().getBundle().getBundleContext(), itemDescriptor.getConnectionInformation(), new ConnectionTracker.Listener(){

            public void setConnection(org.eclipse.scada.core.connection.provider.ConnectionService connectionService) {
                ItemRegistration.this.handleSetConnection((ConnectionService)connectionService);
            }
        });
    }

    public void open() {
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    protected void handleSetConnection(ConnectionService connectionService) {
        logger.info("Connection Set: {}", (Object)connectionService);
        if (connectionService != null) {
            this.attach(connectionService);
        } else {
            this.detach();
        }
    }

    private void detach() {
        if (this.item != null) {
            this.item.unregister();
            this.item = null;
            this.fireUpdate(null);
        }
    }

    private void attach(ConnectionService connectionService) {
        this.detach();
        this.item = new DataItem(this.itemDescriptor.getItemId());
        this.item.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                ItemRegistration.this.handleUpdate((DataItemValue)arg);
            }
        });
        this.item.register(connectionService.getItemManager());
    }

    protected void handleUpdate(DataItemValue value) {
        this.currentValue = value;
        this.fireUpdate(value);
    }

    private void fireUpdate(DataItemValue value) {
        if (this.listener != null) {
            try {
                this.listener.dataItemUpdate(this.key, value);
            }
            catch (Exception e) {
                logger.warn("Failed to fire update", (Throwable)e);
            }
        }
    }

    public DataItemValue getCurrentValue() {
        return this.currentValue;
    }
}

