/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.impl.visibility;

import javax.script.ScriptContext;
import javax.script.ScriptEngineManager;
import org.eclipse.scada.utils.script.ScriptExecutor;
import org.eclipse.scada.vi.details.swt.Activator;
import org.eclipse.scada.vi.details.swt.impl.visibility.AbstractVisibilityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptVisibilityProviderImpl
extends AbstractVisibilityProvider {
    private static final Logger logger = LoggerFactory.getLogger(ScriptVisibilityProviderImpl.class);

    public ScriptVisibilityProviderImpl(ScriptEngineManager scriptEngineManager, ScriptContext scriptContext, String engineName, String scriptCode) {
        this.fireChange(false);
        if (engineName == null || engineName.isEmpty()) {
            engineName = "JavaScript";
        }
        try {
            ScriptExecutor executor = new ScriptExecutor(scriptEngineManager, engineName, scriptCode, Activator.class.getClassLoader());
            this.fireChange(this.makeResult(executor.execute(scriptContext)));
        }
        catch (Exception e) {
            logger.warn("Failed to eval visibility", (Throwable)e);
        }
    }

    private boolean makeResult(Object result) {
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof Number) {
            return ((Number)result).longValue() != 0L;
        }
        return Boolean.parseBoolean(result.toString());
    }

    @Override
    public void dispose() {
    }
}

