/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.Map;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.NullValueException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.details.swt.widgets.GenericComposite;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReadableComposite
extends GenericComposite {
    private static final Logger logger = LoggerFactory.getLogger(ReadableComposite.class);
    protected final DecimalFormat decimalFormat;
    protected final boolean isText;
    private final String attribute;

    public ReadableComposite(Composite parent, int style, String format, String decimal, boolean isText, String attribute) {
        super(parent, style, null, null);
        this.attribute = attribute;
        this.isText = isText;
        this.decimalFormat = decimal == null && !isText ? new DecimalFormat("0.0") : (decimal != null && !isText ? new DecimalFormat(decimal) : null);
    }

    protected String getText(Map<String, DataValue> values, String attribute) {
        String ret;
        Variant value;
        if (attribute == null) {
            try {
                value = values.get("value").getValue().getValue();
            }
            catch (NullPointerException e) {
                logger.info("could not get value", (Throwable)e);
                value = Variant.NULL;
            }
        } else {
            try {
                value = (Variant)values.get("value").getValue().getAttributes().get(attribute);
            }
            catch (NullPointerException e) {
                logger.info("could not get attribute", (Throwable)e);
                value = Variant.NULL;
            }
        }
        try {
            ret = value.asString();
        }
        catch (NullValueException nullValueException) {
            ret = "null";
        }
        catch (NullPointerException nullPointerException) {
            ret = "null";
        }
        return ret;
    }

    protected String getDateAsString(Map<String, DataValue> values, String attribute) {
        Date date;
        Variant value;
        if (attribute == null) {
            try {
                value = values.get("value").getValue().getValue();
            }
            catch (NullPointerException e) {
                logger.info("could not get value", (Throwable)e);
                value = Variant.NULL;
            }
        } else {
            try {
                value = (Variant)values.get("value").getValue().getAttributes().get(attribute);
            }
            catch (NullPointerException e) {
                logger.info("could not get attribute", (Throwable)e);
                value = Variant.NULL;
            }
        }
        try {
            date = new Date(value.asLong());
        }
        catch (NullValueException e) {
            date = new Date(0L);
            logger.error("value is null. can't convert to date: ", (Throwable)e);
        }
        catch (NotConvertableException e) {
            date = new Date(0L);
            logger.error("could not convert value to date: ", (Throwable)e);
        }
        return date.toString();
    }

    protected String getTextDecimal(Map<String, DataValue> values, String attribute) {
        return this.getTextDecimal(values.get("value").getValue(), attribute);
    }

    protected String getTextDecimal(DataItemValue value, String attribute) {
        return this.getTextDecimal(value, attribute, 1.0);
    }

    protected String getTextDecimal(DataItemValue value, String attribute, double factor) {
        String ret;
        Variant var;
        if (attribute == null) {
            try {
                var = value.getValue();
            }
            catch (NullPointerException e) {
                logger.info("could not get value", (Throwable)e);
                var = Variant.NULL;
            }
        } else {
            try {
                var = (Variant)value.getAttributes().get(attribute);
                if (var == null) {
                    logger.info("no attribute");
                    var = Variant.NULL;
                }
            }
            catch (NullPointerException e) {
                logger.info("could not get attribute", (Throwable)e);
                var = Variant.NULL;
            }
        }
        if (value == null) {
            return "null";
        }
        try {
            if (this.decimalFormat == null) {
                ret = var.asString();
            } else {
                try {
                    ret = this.decimalFormat.format(var.asDouble() * factor);
                }
                catch (NotConvertableException e) {
                    ret = "?";
                    logger.error("Could not convert and show double value: {}", (Throwable)e);
                }
            }
        }
        catch (NullValueException nullValueException) {
            ret = "";
            logger.info("No valid data to show value");
        }
        return ret;
    }

    protected String getAttribute() {
        return this.attribute;
    }
}

