/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.exporter.wizard;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.scada.ca.client.Connection;
import org.eclipse.scada.ca.connection.provider.ConnectionService;
import org.eclipse.scada.ca.oscar.OscarWriter;
import org.eclipse.scada.ca.ui.exporter.Activator;
import org.eclipse.scada.ca.ui.exporter.wizard.FileNamePage;
import org.eclipse.scada.ca.ui.exporter.wizard.Messages;
import org.eclipse.scada.ca.ui.util.ConfigurationHelper;
import org.eclipse.scada.ui.databinding.AdapterHelper;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportWizard
extends Wizard
implements IExportWizard {
    private static final Logger logger = LoggerFactory.getLogger(ExportWizard.class);
    private ConnectionService connection;
    private FileNamePage page;

    public ExportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.ExportWizard_WindowTitle);
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection("exportWizard");
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection("exportWizard");
        }
        this.setDialogSettings(Activator.getDefault().getDialogSettings().getSection("exportWizard"));
    }

    public void addPages() {
        super.addPages();
        this.page = new FileNamePage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            final File file = this.page.getFile();
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ExportWizard.this.handleFinish(monitor, file);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            return true;
        }
        catch (Exception e) {
            logger.warn("Failed to export data", (Throwable)e);
            Status status = new Status(4, "org.eclipse.scada.ca.ui.exporter", Messages.ExportWizard_Status_ErrorText, (Throwable)e);
            StatusManager.getManager().handle((IStatus)status, 4);
            return false;
        }
    }

    protected void handleFinish(IProgressMonitor monitor, File file) throws InterruptedException, ExecutionException, FileNotFoundException, IOException {
        Collection data = ConfigurationHelper.loadData((IProgressMonitor)monitor, (Connection)this.connection.getConnection());
        OscarWriter writer = new OscarWriter(ConfigurationHelper.convert((Collection)data), null);
        writer.write(file);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.connection = this.getConnection(selection);
    }

    private ConnectionService getConnection(IStructuredSelection selection) {
        if (selection == null) {
            return null;
        }
        Object o = AdapterHelper.adapt((Object)selection.getFirstElement(), org.eclipse.scada.core.connection.provider.ConnectionService.class);
        if (o instanceof ConnectionService) {
            return (ConnectionService)o;
        }
        return null;
    }
}

