/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.exporter.wizard;

import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scada.ca.ui.exporter.wizard.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileNamePage
extends WizardPage {
    private Text fileName;

    public FileNamePage() {
        super("fileNamePage");
    }

    public void createControl(Composite parent) {
        this.setDescription(Messages.FileNamePage_Description);
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(wrapper, 0);
        label.setText(Messages.FileNamePage_FileLabel);
        this.fileName = new Text(wrapper, 2048);
        this.fileName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        String file = this.getWizard().getDialogSettings().get("fileNamePage.file");
        if (file != null) {
            this.fileName.setText(file);
        }
        this.fileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileNamePage.this.update();
            }
        });
        Button selectFile = new Button(wrapper, 8);
        selectFile.setText(Messages.FileNamePage_BrowseLabel);
        selectFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileNamePage.this.handleSelectFile();
            }
        });
        this.setControl((Control)wrapper);
        this.update();
    }

    protected void update() {
        try {
            this.validate();
            this.setMessage(null, 0);
            this.setPageComplete(true);
        }
        catch (Exception e) {
            this.setMessage(e.getLocalizedMessage(), 3);
            this.setPageComplete(false);
        }
    }

    private void validate() throws Exception {
        String fileName = this.fileName.getText();
        if (fileName.length() == 0) {
            throw new IllegalStateException(Messages.FileNamePage_State_NotFileSelected);
        }
        File file = new File(fileName);
        if (file.exists() && !file.isFile()) {
            throw new IllegalArgumentException(String.format(Messages.FileNamePage_State_FileNoFile, fileName));
        }
        if (!file.canWrite() && file.exists()) {
            throw new IllegalArgumentException(String.format(Messages.FileNamePage_State_FileCantWrite, fileName));
        }
    }

    protected void handleSelectFile() {
        FileDialog dlg = new FileDialog(this.getShell(), 8192);
        dlg.setFilterExtensions(new String[]{"*.oscar", "*.*"});
        dlg.setFilterNames(new String[]{Messages.FileNamePage_OSCARFileType, Messages.FileNamePage_AllTypes});
        if (this.fileName.getText().length() > 0) {
            dlg.setFileName(this.fileName.getText());
        }
        dlg.setFilterIndex(0);
        String file = dlg.open();
        if (file != null) {
            this.fileName.setText(file);
            this.getWizard().getDialogSettings().put("fileNamePage.file", file);
        }
    }

    public File getFile() {
        return new File(this.fileName.getText());
    }
}

