/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.information.details;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapCellLabelProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.ui.connection.information.details.AbstractConnectionTab;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesTab
extends AbstractConnectionTab {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesTab.class);
    private TabItem item;
    private TableViewer viewer;
    private ObservableListContentProvider contentProvider;
    private WritableList list;
    private Connection connection;

    @Override
    protected void setConnection(Connection connection) {
        if (this.list.isDisposed()) {
            return;
        }
        this.connection = connection;
        if (connection != null) {
            this.performUpdate(connection.getSessionProperties());
        } else {
            this.performUpdate(Collections.<String, String>emptyMap());
        }
    }

    private void performUpdate(final Map<String, String> properties) {
        this.list.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                PropertiesTab.this.handleUpdate(properties);
            }
        });
    }

    protected void handleUpdate(Map<String, String> sessionProperties) {
        logger.trace("Handle session properties update: {}", sessionProperties);
        this.list.setStale(true);
        try {
            this.list.clear();
            if (sessionProperties != null) {
                for (Map.Entry<String, String> entry : sessionProperties.entrySet()) {
                    this.list.add((Object)new Entry(entry.getKey(), entry.getValue()));
                }
            }
        }
        finally {
            this.list.setStale(false);
        }
    }

    @Override
    public void createTab(TabFolder tabFolder) {
        this.item = new TabItem(tabFolder, 66304);
        this.item.setText("Properties");
        this.item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PropertiesTab.this.handleDispose();
            }
        });
        this.viewer = new TableViewer((Composite)tabFolder);
        this.viewer.getTable().setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        this.viewer.getTable().setLayout((Layout)layout);
        this.contentProvider = new ObservableListContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.list = new WritableList(SWTObservables.getRealm((Display)tabFolder.getDisplay()));
        TableViewerColumn col = new TableViewerColumn(this.viewer, 0);
        col.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(PojoObservables.observeMap((IObservableSet)this.contentProvider.getKnownElements(), Entry.class, (String)"key")));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        col.getColumn().setText("Key");
        col = new TableViewerColumn(this.viewer, 0);
        col.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(PojoObservables.observeMap((IObservableSet)this.contentProvider.getKnownElements(), Entry.class, (String)"value")));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        col.getColumn().setText("Value");
        this.item.setControl(this.viewer.getControl());
        this.viewer.setInput((Object)this.list);
        this.triggerTimer();
    }

    private void triggerTimer() {
        if (this.list.isDisposed()) {
            return;
        }
        this.list.getRealm().timerExec(1000, new Runnable(){

            @Override
            public void run() {
                PropertiesTab.this.performUpdate();
                PropertiesTab.this.triggerTimer();
            }
        });
    }

    protected void performUpdate() {
        Connection connection = this.connection;
        if (connection == null) {
            this.handleUpdate(Collections.<String, String>emptyMap());
            return;
        }
        this.handleUpdate(connection.getSessionProperties());
    }

    protected void handleDispose() {
        this.setConnection(null);
    }

    private static class Entry {
        private final String key;
        private final String value;

        private Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

