/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.ui.connection.ConnectionDescriptor;
import org.eclipse.scada.core.ui.connection.data.ConnectionDiscovererBean;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolder;
import org.eclipse.scada.ui.databinding.CommonListeningLabelProvider;
import org.eclipse.scada.ui.databinding.StyledViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionLabelProvider
extends CommonListeningLabelProvider
implements PropertyChangeListener,
IDescriptionProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionLabelProvider.class);
    private final ResourceManager resource = new LocalResourceManager(JFaceResources.getResources());

    public ConnectionLabelProvider() {
        super("org.eclipse.scada.core.ui.connection.provider");
    }

    public void dispose() {
        this.resource.dispose();
        super.dispose();
    }

    private StyledString getConnectionString(ConnectionHolder holder) {
        ConnectionService service = holder.getConnectionService();
        ConnectionDescriptor desc = holder.getConnectionInformation();
        StyledString str = new StyledString(this.makeLabel(desc.getConnectionInformation()));
        if (service != null) {
            str.append(" [", StyledString.DECORATIONS_STYLER);
            Connection connection = service.getConnection();
            if (connection != null) {
                str.append(String.format("%s", holder.getConnectionState()), StyledString.DECORATIONS_STYLER);
            }
            str.append("]", StyledString.DECORATIONS_STYLER);
        }
        if (desc.getServiceId() != null) {
            str.append(String.format(" (%s)", desc.getServiceId()), StyledString.QUALIFIER_STYLER);
        }
        return str;
    }

    private String makeLabel(ConnectionInformation connectionInformation) {
        return connectionInformation.toMaskedString();
    }

    public void updateLabel(StyledViewerLabel label, Object element) {
        if (element instanceof ConnectionDiscovererBean) {
            ConnectionDiscovererBean bean = (ConnectionDiscovererBean)element;
            if (bean.getImageDescriptor() != null) {
                label.setImage(this.resource.createImage(((ConnectionDiscovererBean)element).getImageDescriptor()));
            }
            label.setText(bean.getName());
        } else if (element instanceof ConnectionHolder) {
            Image image = this.resource.createImage(ImageDescriptor.createFromFile(ConnectionLabelProvider.class, (String)"icons/connection.gif"));
            label.setImage(image);
            label.setStyledText(this.getConnectionString((ConnectionHolder)((Object)element)));
        }
    }

    public String getDescription(Object element) {
        if (element instanceof ConnectionDiscovererBean) {
            return ((ConnectionDiscovererBean)element).getDescription();
        }
        if (element instanceof ConnectionHolder) {
            return ((ConnectionHolder)((Object)element)).getConnectionInformation().getDescription();
        }
        return super.getDescription(element);
    }

    protected void addListenerTo(Object next) {
        super.addListenerTo(next);
        if (next instanceof ConnectionHolder) {
            ((ConnectionHolder)((Object)next)).addPropertyChangeListener(this);
        }
    }

    protected void removeListenerFrom(Object next) {
        if (next instanceof ConnectionHolder) {
            ((ConnectionHolder)((Object)next)).removePropertyChangeListener(this);
        }
        super.removeListenerFrom(next);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        logger.debug("Detected a property change: {}", (Object)evt);
        this.fireChangeEvent(Arrays.asList(evt.getSource()));
    }
}

