/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.views.tree;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.core.ui.connection.views.tree.TreeNode;
import org.eclipse.scada.ui.databinding.CommonListeningLabelProvider;
import org.eclipse.scada.ui.databinding.StyledViewerLabel;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionTreeLabelProvider
extends CommonListeningLabelProvider
implements PropertyChangeListener,
IDescriptionProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionTreeLabelProvider.class);
    private final ResourceManager resource = new LocalResourceManager(JFaceResources.getResources());

    public ConnectionTreeLabelProvider() {
        super("org.eclipse.scada.core.tree.ui.connection.provider");
    }

    public void dispose() {
        this.resource.dispose();
        super.dispose();
    }

    public void updateLabel(StyledViewerLabel label, Object element) {
        if (element instanceof TreeNode) {
            TreeNode node = (TreeNode)element;
            label.setText(node.getName());
        }
    }

    public String getDescription(Object element) {
        if (element instanceof TreeNode) {
            return null;
        }
        return super.getDescription(element);
    }

    protected void addListenerTo(Object next) {
        super.addListenerTo(next);
    }

    protected void removeListenerFrom(Object next) {
        super.removeListenerFrom(next);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        logger.debug("Detected a property change: {}", (Object)evt);
        this.fireChangeEvent(Arrays.asList(evt.getSource()));
    }
}

