/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.views.tree;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.scada.core.ui.connection.ConnectionDescriptor;
import org.eclipse.scada.core.ui.connection.data.ConnectionDiscovererBean;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolder;
import org.eclipse.scada.core.ui.connection.views.tree.ConnectionPoolManager;

public class DiscovererListener {
    private final ConnectionDiscovererBean connectionDiscoverer;
    private final ISetChangeListener setListener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            DiscovererListener.this.handleSetChange(event.diff);
        }
    };
    private final ConnectionPoolManager poolManager;

    public DiscovererListener(ConnectionDiscovererBean connectionDiscoverer, ConnectionPoolManager poolManager) {
        this.connectionDiscoverer = connectionDiscoverer;
        this.poolManager = poolManager;
        connectionDiscoverer.getKnownConnections().addSetChangeListener(this.setListener);
        this.handleSetChange(Diffs.createSetDiff((Set)connectionDiscoverer.getKnownConnections(), Collections.emptySet()));
    }

    protected void handleSetChange(SetDiff diff) {
        HashSet<ConnectionDescriptor> additions = new HashSet<ConnectionDescriptor>(diff.getAdditions().size());
        HashSet<ConnectionDescriptor> removals = new HashSet<ConnectionDescriptor>(diff.getRemovals().size());
        for (Object o : diff.getAdditions()) {
            if (!(o instanceof ConnectionHolder)) continue;
            additions.add(((ConnectionHolder)((Object)o)).getConnectionInformation());
        }
        for (Object o : diff.getRemovals()) {
            if (!(o instanceof ConnectionHolder)) continue;
            removals.add(((ConnectionHolder)((Object)o)).getConnectionInformation());
        }
        this.poolManager.handleChange(this, additions, removals);
    }

    public void dispose() {
        this.connectionDiscoverer.getKnownConnections().removeSetChangeListener(this.setListener);
        this.handleSetChange(Diffs.createSetDiff(Collections.emptySet(), (Set)this.connectionDiscoverer.getKnownConnections()));
    }

    public IObservableSet getConnections() {
        return this.connectionDiscoverer.getKnownConnections();
    }
}

