/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.views.tree.node;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolder;
import org.eclipse.scada.core.ui.connection.views.tree.node.DelegatingTreeNode;

public class GroupChildNode
extends DelegatingTreeNode {
    private final GroupChildNode parentNode;
    private final Map<String, GroupChildNode> children = new HashMap<String, GroupChildNode>();
    private final Realm realm;

    public GroupChildNode(Realm realm, String name, GroupChildNode parentNode) {
        super(realm, name);
        this.realm = realm;
        this.parentNode = parentNode;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    protected void addPath(List<String> path, ConnectionHolder holder) {
        if (path.isEmpty()) {
            this.implNode.getConnections().add((Object)holder);
        } else {
            String name = path.get(0);
            path.remove(0);
            GroupChildNode child = this.children.get(name);
            if (child == null) {
                child = new GroupChildNode(this.realm, name, this);
                this.children.put(name, child);
                this.implNode.getChildren().add((Object)child);
            }
            child.addPath(path, holder);
        }
    }

    protected void removePath(List<String> path, ConnectionHolder holder) {
        if (path.isEmpty()) {
            this.implNode.getConnections().remove((Object)holder);
            if (this.implNode.getConnections().isEmpty() && this.parentNode != null) {
                this.parentNode.notifyEmpty(this, this.implNode.getName());
            }
        } else {
            String name = path.get(0);
            path.remove(0);
            GroupChildNode child = this.children.get(name);
            if (child != null) {
                child.removePath(path, holder);
            }
        }
    }

    protected void notifyEmpty(GroupChildNode groupChildNode, String name) {
        this.implNode.getChildren().remove((Object)groupChildNode);
        groupChildNode.dispose();
        this.children.remove(name);
    }
}

