/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.user;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scada.ui.utils.AbstractSelectionProvider;
import org.eclipse.scada.vi.ui.user.Activator;
import org.eclipse.scada.vi.ui.user.viewer.ViewInstance;
import org.eclipse.scada.vi.ui.user.viewer.ViewInstanceDescriptor;
import org.eclipse.scada.vi.ui.user.viewer.ViewManager;
import org.eclipse.scada.vi.ui.user.viewer.ViewManagerContext;
import org.eclipse.scada.vi.ui.user.viewer.ViewManagerListener;
import org.eclipse.scada.vi.ui.user.viewer.ext.ExtensionDescriptor;
import org.eclipse.scada.vi.ui.user.viewer.ext.ViewerExtension;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleVisualInterfaceViewPart
extends ViewPart
implements ViewManager,
ViewManagerContext {
    private static final Logger logger = LoggerFactory.getLogger(SingleVisualInterfaceViewPart.class);
    private Composite viewHolder;
    private final Map<String, ViewInstance> instances = new LinkedHashMap<String, ViewInstance>(1);
    private ViewInstance currentInstance;
    private StackLayout stackLayout;
    private ResourceManager manager;
    private final List<ViewInstanceDescriptor> descriptors;
    private final Set<ViewInstanceDescriptor> visibleDescriptors = new HashSet<ViewInstanceDescriptor>();
    private boolean switchingView;
    private ISelectionProvider selectionProvider;
    private final Set<ViewManagerListener> viewManagerListeners = new LinkedHashSet<ViewManagerListener>();

    public SingleVisualInterfaceViewPart() {
        this.descriptors = new ArrayList<ViewInstanceDescriptor>(Activator.getDescriptors());
        Collections.sort(this.descriptors, ViewInstanceDescriptor.DESCRIPTOR_ORDER_COMPARATOR);
    }

    public void createPartControl(Composite parent) {
        this.manager = new LocalResourceManager(JFaceResources.getResources());
        parent.setLayout((Layout)new FillLayout());
        this.selectionProvider = new AbstractSelectionProvider();
        this.getSite().setSelectionProvider(this.selectionProvider);
        List<ExtensionDescriptor> extensions = Activator.getExtensionDescriptors();
        Composite wrapper = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        wrapper.setLayout((Layout)gridLayout);
        Composite topComposite = new Composite(wrapper, 0);
        topComposite.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        topComposite.setLayout(this.createExtensionGridLayout());
        Composite leftComposite = new Composite(wrapper, 0);
        leftComposite.setLayoutData((Object)new GridData(4, 4, false, true));
        leftComposite.setLayout(this.createExtensionGridLayout());
        this.viewHolder = new Composite(wrapper, 0);
        this.viewHolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.stackLayout = new StackLayout();
        this.viewHolder.setLayout((Layout)this.stackLayout);
        Composite rightComposite = new Composite(wrapper, 0);
        rightComposite.setLayoutData((Object)new GridData(4, 4, false, true));
        rightComposite.setLayout(this.createExtensionGridLayout());
        Composite bottomComposite = new Composite(wrapper, 0);
        bottomComposite.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        bottomComposite.setLayout(this.createExtensionGridLayout());
        try {
            this.createExtensions(extensions, topComposite, "TOP", true);
            this.createExtensions(extensions, bottomComposite, "BOTTOM", true);
            this.createExtensions(extensions, leftComposite, "LEFT", false);
            this.createExtensions(extensions, rightComposite, "RIGHT", false);
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e, "org.eclipse.scada.vi.ui.user");
        }
        for (ViewInstanceDescriptor descriptor : this.descriptors) {
            this.createAndAddView(descriptor);
        }
        this.activateNextMain();
    }

    private Layout createExtensionGridLayout() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        return gridLayout;
    }

    private void createExtensions(List<ExtensionDescriptor> extensions, Composite composite, String location, boolean horizontal) throws CoreException {
        int count = 0;
        for (ExtensionDescriptor extension : extensions) {
            Control result;
            ViewerExtension viewerExtension;
            if (!location.equals(extension.getLocation()) || (viewerExtension = extension.createExtension()) == null || (result = viewerExtension.create(composite, this, horizontal)) == null) continue;
            ++count;
            String align = extension.getAlign();
            if ("END".equalsIgnoreCase(align)) {
                result.setLayoutData((Object)new GridData(horizontal ? 4 : 0x1000008, 4, !horizontal, horizontal));
                continue;
            }
            if ("FILL".equalsIgnoreCase(align)) {
                result.setLayoutData((Object)new GridData(4, 4, true, true));
                continue;
            }
            result.setLayoutData((Object)new GridData(horizontal ? 4 : 1, 4, !horizontal, horizontal));
        }
        if (composite.getLayout() instanceof GridLayout) {
            ((GridLayout)composite.getLayout()).numColumns = count;
        }
    }

    private void updateSelection() {
        StructuredSelection sel = this.currentInstance == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)this.currentInstance);
        logger.debug("Setting selection: {}", (Object)sel);
        this.selectionProvider.setSelection((ISelection)sel);
    }

    public void dispose() {
        super.dispose();
        this.manager.dispose();
    }

    private ViewInstance createAndAddView(ViewInstanceDescriptor descriptor) {
        ViewInstance instance = descriptor.getFactory().createViewInstance(this, this, descriptor, this.viewHolder, this.manager, this.getSite());
        this.instances.put(descriptor.getId(), instance);
        return instance;
    }

    @Override
    public void showView(String id) {
        this.showView(id, false);
    }

    @Override
    public void showView(String id, boolean force) {
        ViewInstance instance = this.instances.get(id);
        if (instance == null) {
            return;
        }
        this.showView(instance, force);
    }

    protected void showView(ViewInstance instance, boolean force) {
        if (this.currentInstance == instance && !force) {
            return;
        }
        this.switchingView = true;
        try {
            if (this.currentInstance != null) {
                this.currentInstance.deactivate();
            }
            this.currentInstance = instance;
            this.currentInstance.activate();
            this.updateTopControl();
        }
        finally {
            this.switchingView = false;
        }
        this.updateSelection();
    }

    private void updateTopControl() {
        this.stackLayout.topControl = this.currentInstance.getControl();
        this.viewHolder.layout();
    }

    public void setFocus() {
        if (this.currentInstance != null) {
            this.currentInstance.setFocus();
        }
    }

    protected static boolean hasParent(ViewInstanceDescriptor descriptor) {
        return descriptor.getParentId() != null && !descriptor.getParentId().isEmpty();
    }

    @Override
    public void viewVisibilityChanged(ViewInstance viewInstance, boolean visible) {
        this.fireViewVisibilityChanged(viewInstance, visible);
        if (visible) {
            this.visibleDescriptors.add(viewInstance.getDescriptor());
        } else {
            this.visibleDescriptors.remove(viewInstance.getDescriptor());
        }
        if (this.currentInstance == viewInstance && !visible) {
            this.currentInstance.deactivate();
            this.currentInstance = null;
            this.stackLayout.topControl = null;
            this.viewHolder.layout();
        }
        if (this.currentInstance == null) {
            this.activateNextMain();
        }
    }

    private void fireViewVisibilityChanged(final ViewInstance viewInstance, final boolean visible) {
        for (final ViewManagerListener listener : this.viewManagerListeners) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.viewVisibilityChanged(viewInstance, visible);
                }
            });
        }
    }

    protected void activateNextMain() {
        List<ViewInstanceDescriptor> descriptors = this.findVisibleMains();
        if (!descriptors.isEmpty()) {
            this.showView(descriptors.get(0).getId(), true);
        }
    }

    protected List<ViewInstanceDescriptor> findVisibleMains() {
        LinkedList<ViewInstanceDescriptor> result = new LinkedList<ViewInstanceDescriptor>();
        for (ViewInstanceDescriptor desc : this.visibleDescriptors) {
            ViewInstance instance = this.instances.get(desc.getId());
            if (instance == null || !instance.isDefaultInstance()) continue;
            result.add(desc);
        }
        Collections.sort(result, ViewInstanceDescriptor.DESCRIPTOR_ORDER_COMPARATOR);
        return result;
    }

    @Override
    public void viewDefaultChanged(ViewInstance viewInstance, boolean state) {
        if (this.currentInstance == null) {
            this.activateNextMain();
        }
    }

    @Override
    public void viewActiveChanged(ViewInstance viewInstance, boolean state) {
        if (!state && !this.switchingView && this.currentInstance == viewInstance) {
            this.currentInstance = null;
            this.activateNextMain();
        }
        this.fireActiveChanged(viewInstance, state);
    }

    private void fireActiveChanged(final ViewInstance viewInstance, final boolean state) {
        for (final ViewManagerListener listener : this.viewManagerListeners) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.viewActiveChanged(viewInstance, state);
                }
            });
        }
    }

    @Override
    public void viewLazynessChanged(ViewInstance viewInstance, boolean state) {
        logger.debug("viewLazynessChanged : {} - {}", (Object)viewInstance.getDescriptor(), (Object)state);
        this.fireLazyStateChanged(viewInstance, state);
    }

    private void fireLazyStateChanged(final ViewInstance viewInstance, final boolean state) {
        for (final ViewManagerListener listener : this.viewManagerListeners) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.viewLazynessChanged(viewInstance, state);
                }
            });
        }
    }

    @Override
    public void viewControlChanged(ViewInstance viewInstance) {
        if (this.currentInstance == viewInstance) {
            this.updateTopControl();
        }
    }

    @Override
    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        this.getSite().setSelectionProvider(selectionProvider);
    }

    @Override
    public void addViewManagerListener(ViewManagerListener listener) {
        this.viewManagerListeners.add(listener);
    }

    @Override
    public void removeViewManagerListener(ViewManagerListener listener) {
        this.viewManagerListeners.remove(listener);
    }

    @Override
    public void reloadCurrentView() {
        if (this.currentInstance != null) {
            this.currentInstance.reload();
        }
    }

    @Override
    public void registerMenuManager(MenuManager menuManager) {
        this.updateSelection();
        this.getSite().registerContextMenu(menuManager, this.selectionProvider);
    }
}

