/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.user.navigation;

import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.data.SummaryListener;
import org.eclipse.scada.vi.data.SummaryProvider;
import org.eclipse.scada.vi.ui.user.navigation.StateListener;
import org.eclipse.scada.vi.ui.user.navigation.StateProvider;

public class DelegatingSummaryProvider
implements StateProvider {
    private final SummaryProvider summaryProvider;
    private final StateListener listener;
    private final SummaryListener summaryListener = new SummaryListener(){

        public void summaryChanged(SummaryInformation summaryInformation) {
            DelegatingSummaryProvider.this.handleSummaryChanged(summaryInformation);
        }
    };

    public DelegatingSummaryProvider(SummaryProvider summaryProvider, StateListener listener) {
        this.summaryProvider = summaryProvider;
        this.listener = listener;
        this.summaryProvider.addSummaryListener(this.summaryListener);
        SummaryInformation currentSummary = summaryProvider.getSummary();
        if (currentSummary != null && listener != null) {
            listener.stateChange(currentSummary.getStateInformation());
        }
    }

    protected void handleSummaryChanged(SummaryInformation summaryInformation) {
        if (this.listener != null && summaryInformation != null) {
            this.listener.stateChange(summaryInformation.getStateInformation());
        }
    }

    @Override
    public void dispose() {
        this.summaryProvider.removeSummaryListener(this.summaryListener);
    }
}

