/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.testing.views;

import java.util.List;
import java.util.Set;
import org.eclipse.scada.ae.client.MonitorListener;
import org.eclipse.scada.ae.data.BrowserType;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.ui.connection.data.BrowserEntryBean;
import org.eclipse.scada.ae.ui.testing.views.AbstractEntryViewPart;
import org.eclipse.scada.core.data.SubscriptionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConditionQueryViewPart
extends AbstractEntryViewPart {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConditionQueryViewPart.class);
    private ConditionListenerImpl listener;

    @Override
    protected boolean isSupported(BrowserEntryBean query) {
        return query.getEntry().getTypes().contains(BrowserType.MONITORS);
    }

    @Override
    protected void setEntry(BrowserEntryBean query) {
        logger.info("Setting entry: {}", (Object)query);
        this.entry = query;
        if (this.listener != null) {
            this.listener.dispose();
            this.listener = null;
        }
        this.listener = new ConditionListenerImpl();
        this.entry.getConnection().getConnection().setMonitorListener(this.entry.getEntry().getId(), (MonitorListener)this.listener);
    }

    protected abstract void handleDataChanged(List<MonitorStatusInformation> var1, Set<String> var2, boolean var3);

    protected abstract void handleStatusChanged(SubscriptionState var1);

    @Override
    protected void clear() {
        if (this.entry != null) {
            if (this.listener != null) {
                this.listener.dispose();
                this.listener = null;
            }
            this.entry.getConnection().getConnection().setMonitorListener(this.entry.getEntry().getId(), null);
            this.entry = null;
        }
    }

    protected final class ConditionListenerImpl
    implements MonitorListener {
        private boolean disposed = false;

        protected ConditionListenerImpl() {
        }

        public synchronized void dispose() {
            this.disposed = true;
        }

        public synchronized void statusChanged(SubscriptionState state) {
            if (!this.disposed) {
                AbstractConditionQueryViewPart.this.handleStatusChanged(state);
            }
        }

        public synchronized void dataChanged(List<MonitorStatusInformation> addedOrUpdated, Set<String> removed, boolean full) {
            if (!this.disposed) {
                AbstractConditionQueryViewPart.this.handleDataChanged(addedOrUpdated, removed, full);
            }
        }
    }
}

