/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.ui.providers.internal;

import java.util.Date;
import org.eclipse.scada.sec.ui.providers.KeyInformation;
import org.eclipse.scada.sec.ui.providers.KeyInstanceManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class KeyInstanceManagerStatus
extends WorkbenchWindowControlContribution
implements KeyInstanceManager.StatusListener {
    private Display display;
    private Label label;
    private KeyInformation key;
    private Date validUntil;
    private final Runnable updateRunner = new Runnable(){

        @Override
        public void run() {
            KeyInstanceManagerStatus.this.updateTimeout();
        }
    };

    public KeyInstanceManagerStatus() {
    }

    public KeyInstanceManagerStatus(String id) {
        super(id);
    }

    protected Control createControl(Composite parent) {
        this.display = parent.getDisplay();
        KeyInstanceManager.getInstance(parent.getDisplay()).addStatusListener(this);
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new GridLayout(1, false));
        this.label = new Label(wrapper, 0);
        GridData gd = new GridData(4, 4, false, true);
        gd.widthHint = 150;
        this.label.setLayoutData((Object)gd);
        this.display.timerExec(500, this.updateRunner);
        this.updateLabel();
        return wrapper;
    }

    protected void updateTimeout() {
        if (this.label.isDisposed()) {
            return;
        }
        this.display.timerExec(500, this.updateRunner);
        this.updateLabel();
    }

    @Override
    public void defaultKeyChanged(KeyInformation key, Date validUntil) {
        this.key = key;
        this.validUntil = validUntil;
        this.updateLabel();
    }

    private void updateLabel() {
        StringBuilder sb = new StringBuilder("");
        if (this.key != null) {
            long seconds;
            if (this.validUntil != null && (seconds = (this.validUntil.getTime() - System.currentTimeMillis()) / 1000L) > 0L) {
                sb.append(String.format("%d:%02d ", seconds / 60L, seconds % 60L));
            }
            sb.append("" + this.key);
        }
        this.label.setToolTipText(sb.toString());
        this.label.setText(sb.toString());
    }

    public void dispose() {
        KeyInstanceManager.getInstance(this.display).removeStatusListener(this);
        super.dispose();
    }
}

