/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.draw2d;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.ui.draw2d.SymbolController;

public class SymbolData {
    private final SymbolController controller;

    public SymbolData(SymbolController symbolController) {
        this.controller = symbolController;
    }

    public Map<String, DataItemValue> getValues() {
        return this.convert(this.controller.getRegistrationManagerData());
    }

    private Map<String, DataItemValue> convert(Map<String, DataValue> data) {
        LinkedHashMap<String, DataItemValue> values = new LinkedHashMap<String, DataItemValue>(data.size());
        for (Map.Entry<String, DataValue> entry : data.entrySet()) {
            if (entry.getValue() == null) continue;
            values.put(entry.getKey(), entry.getValue().getValue());
        }
        return values;
    }

    public DataItemValue getValue(String name) {
        DataValue dv = this.controller.getRegistrationManagerData().get(name);
        if (dv == null) {
            return null;
        }
        return dv.getValue();
    }

    public Variant getPrimaryValue(String name) {
        DataItemValue div = this.getValue(name);
        if (div == null) {
            return Variant.NULL;
        }
        return div.getValue();
    }

    public boolean isError(String name) {
        DataItemValue div = this.getValue(name);
        if (div == null) {
            return true;
        }
        return !div.isConnected() || div.isError();
    }

    public boolean isAlarm(String name) {
        DataItemValue div = this.getValue(name);
        if (div == null) {
            return false;
        }
        return div.isAlarm();
    }

    public boolean isManual(String name) {
        DataItemValue div = this.getValue(name);
        if (div == null) {
            return false;
        }
        return div.isManual();
    }

    public boolean isBlocked(String name) {
        DataItemValue div = this.getValue(name);
        if (div == null) {
            return false;
        }
        return div.isBlocked();
    }

    public boolean isAckRequired(String name) {
        DataItemValue div = this.getValue(name);
        if (div == null) {
            return false;
        }
        return div.isAttribute("ackRequired", false);
    }

    public boolean isValid(String name) {
        DataItemValue div = this.getValue(name);
        if (div == null) {
            return false;
        }
        return div.isConnected() && !div.isError() && div.getValue() != null && !div.getValue().isNull();
    }

    public boolean isAttributeWithDefault(String name, String attributeName, boolean defaultValue) {
        DataItemValue div = this.getValue(name);
        if (div == null) {
            return defaultValue;
        }
        Variant attr = (Variant)div.getAttributes().get(attributeName);
        if (attr == null || attr.isNull()) {
            return defaultValue;
        }
        return attr.asBoolean();
    }

    public Variant getAttributeValue(String name, String attributeName) {
        DataItemValue div = this.getValue(name);
        if (div == null) {
            return Variant.NULL;
        }
        Variant attr = (Variant)div.getAttributes().get(attributeName);
        if (attr == null) {
            return Variant.NULL;
        }
        return attr;
    }

    public SummaryInformation getSummary() {
        return this.controller.getSummaryInformation();
    }
}

