/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.login;

import java.util.Collection;
import org.eclipse.scada.core.ui.connection.login.LoginContext;
import org.eclipse.scada.core.ui.connection.login.LoginHandler;
import org.osgi.framework.BundleContext;

public class LoginSession {
    private final String username;
    private final String password;
    private final BundleContext context;
    private final LoginContext loginContext;
    private final Collection<LoginHandler> handler;

    public LoginSession(BundleContext context, String username, String password, LoginContext loginContext, Collection<LoginHandler> handler) {
        this.context = context;
        this.username = username;
        this.password = password;
        this.loginContext = loginContext;
        this.handler = handler;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public LoginContext getLoginContext() {
        return this.loginContext;
    }

    public void register() {
        for (LoginHandler handler : this.handler) {
            handler.register(this.context);
        }
    }

    public void dispose() {
        for (LoginHandler handler : this.handler) {
            handler.dispose();
        }
    }

    public boolean hasRole(String role) {
        for (LoginHandler handler : this.handler) {
            if (!handler.hasRole(role)) continue;
            return true;
        }
        return false;
    }
}

