/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.login.dialog;

import java.net.ConnectException;
import java.util.HashSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scada.core.ui.connection.login.dialog.ContextCreatorListener;
import org.eclipse.scada.core.ui.connection.login.dialog.Messages;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ConnectionAnalyzer
extends Composite
implements ContextCreatorListener {
    private final TableViewer tableViewer;
    private final WritableSet dataSet;

    public ConnectionAnalyzer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.tableViewer = new TableViewer((Composite)this, style | 0x10000);
        TableViewerColumn col = new TableViewerColumn(this.tableViewer, 0);
        col.getColumn().setText(Messages.ConnectionAnalyzer_Column_Text_Uri);
        col.setLabelProvider((CellLabelProvider)new LabelProvider());
        col = new TableViewerColumn(this.tableViewer, 0);
        col.getColumn().setText(Messages.ConnectionAnalyzer_Column_Text_State);
        col.setLabelProvider((CellLabelProvider)new LabelProvider());
        col = new TableViewerColumn(this.tableViewer, 0);
        col.getColumn().setText(Messages.ConnectionAnalyzer_Column_Text_Error);
        col.setLabelProvider((CellLabelProvider)new LabelProvider());
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(200));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(400));
        this.tableViewer.getTable().setLayout((Layout)tableLayout);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.dataSet = new WritableSet();
        this.tableViewer.setContentProvider((IContentProvider)new ObservableSetContentProvider());
        this.tableViewer.setInput((Object)this.dataSet);
        this.tableViewer.setItemCount(5);
    }

    public static String makeError(Throwable error) {
        if (error == null) {
            return null;
        }
        HashSet<Throwable> causes = new HashSet<Throwable>(1);
        while (error.getCause() != null && !causes.contains(error)) {
            causes.add(error);
            error = error.getCause();
        }
        if (error instanceof ConnectException || error instanceof java.rmi.ConnectException) {
            return String.format(Messages.ConnectionAnalyzer_Error_ConnectException, error.getLocalizedMessage());
        }
        String msg = error.getLocalizedMessage();
        if (msg == null) {
            return error.getClass().getName();
        }
        if ("Bad credentials".equals(msg)) {
            return Messages.ConnectionAnalyzer_Error_BadCredentials;
        }
        return msg;
    }

    public void clear() {
        this.tableViewer.setItemCount(0);
        this.dataSet.clear();
    }

    @Override
    public void stateChanged(String handlerName, String state, Throwable error) {
        if (this.isDisposed()) {
            return;
        }
        Entry entry = new Entry(handlerName, state, error);
        try {
            this.dataSet.setStale(true);
            for (Entry currentEntry : this.dataSet) {
                if (!currentEntry.equals(entry) || currentEntry.getError() == null || entry.getError() != null) continue;
                entry = new Entry(handlerName, state, currentEntry.getError());
            }
            this.dataSet.remove((Object)entry);
            this.dataSet.add((Object)entry);
        }
        finally {
            this.dataSet.setStale(false);
        }
    }

    private static class Entry {
        private final String handlerName;
        private final String state;
        private final Throwable error;

        public Entry(String handlerName, String state, Throwable error) {
            this.handlerName = handlerName;
            this.state = state;
            this.error = error;
        }

        public String getHandlerName() {
            return this.handlerName;
        }

        public Throwable getError() {
            return this.error;
        }

        public String getState() {
            return this.state;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.handlerName == null ? 0 : this.handlerName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)obj;
            return !(this.handlerName == null ? other.handlerName != null : !this.handlerName.equals(other.handlerName));
        }
    }

    private static class LabelProvider
    extends CellLabelProvider {
        private LabelProvider() {
        }

        public void update(ViewerCell cell) {
            Entry entry = (Entry)cell.getElement();
            switch (cell.getColumnIndex()) {
                case 0: {
                    cell.setText(entry.getHandlerName());
                    break;
                }
                case 1: {
                    cell.setText(entry.getState().toString());
                    break;
                }
                case 2: {
                    String errorText = ConnectionAnalyzer.makeError(entry.getError());
                    if (errorText == null) break;
                    cell.setText(errorText);
                }
            }
        }
    }
}

