/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.connection.data;

import java.util.Map;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;
import org.eclipse.scada.core.connection.provider.ConnectionIdTracker;
import org.eclipse.scada.core.connection.provider.ConnectionRequest;
import org.eclipse.scada.core.connection.provider.ConnectionRequestTracker;
import org.eclipse.scada.core.connection.provider.ConnectionTracker;
import org.eclipse.scada.core.data.OperationParameters;
import org.eclipse.scada.da.connection.provider.ConnectionService;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.da.ui.connection.data.ItemListenerHolder;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractItemHolder {
    private static final Logger logger = LoggerFactory.getLogger(AbstractItemHolder.class);
    protected final Item item;
    private final BundleContext context;
    private final ConnectionTracker tracker;
    private ConnectionService connection;
    private final ItemListenerHolder.HolderListener holderListener;
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        public void stateChange(Connection connection, ConnectionState state, Throwable error) {
            AbstractItemHolder.this.fireConnectionStateChange(connection, state, error);
        }
    };

    public AbstractItemHolder(BundleContext context, Item item, ItemListenerHolder.HolderListener holderListener) {
        this.context = context;
        this.item = item;
        this.holderListener = holderListener;
        switch (item.getType()) {
            case ID: {
                this.tracker = new ConnectionIdTracker(this.context, item.getConnectionString(), new ConnectionTracker.Listener(){

                    public void setConnection(org.eclipse.scada.core.connection.provider.ConnectionService connectionService) {
                        AbstractItemHolder.this.setConnection((ConnectionService)connectionService);
                    }
                });
                break;
            }
            default: {
                this.tracker = new ConnectionRequestTracker(this.context, this.createRequest(), new ConnectionTracker.Listener(){

                    public void setConnection(org.eclipse.scada.core.connection.provider.ConnectionService connectionService) {
                        AbstractItemHolder.this.setConnection((ConnectionService)connectionService);
                    }
                });
            }
        }
    }

    protected synchronized void init() {
        this.tracker.listen();
    }

    protected synchronized void setConnection(ConnectionService connectionService) {
        this.fireConnectionChange(connectionService);
        try {
            if (this.connection != null) {
                this.unbindConnection();
            }
            if (connectionService != null) {
                this.bindConnection(connectionService);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to set connection", (Throwable)e);
        }
    }

    protected void fireConnectionChange(ConnectionService connection) {
        if (this.holderListener != null) {
            try {
                this.holderListener.connectionChange(connection);
            }
            catch (Exception e) {
                logger.warn("Listener threw exception", (Throwable)e);
            }
        }
    }

    protected void fireConnectionStateChange(Connection connection, ConnectionState state, Throwable error) {
        if (this.holderListener != null) {
            try {
                this.holderListener.connectionStateChange(connection, state, error);
            }
            catch (Exception e) {
                logger.warn("Listener threw exception", (Throwable)e);
            }
        }
    }

    protected void bindConnection(ConnectionService connectionService) {
        this.connection = connectionService;
        if (this.holderListener != null) {
            this.connection.getConnection().addConnectionStateListener(this.connectionStateListener);
        }
    }

    protected void unbindConnection() {
        if (this.holderListener != null) {
            this.connection.getConnection().removeConnectionStateListener(this.connectionStateListener);
        }
        this.connection = null;
    }

    protected ConnectionRequest createRequest() {
        return new ConnectionRequest(null, ConnectionInformation.fromURI((String)this.item.getConnectionString()), null, false);
    }

    public synchronized void dispose() {
        this.unbindConnection();
        this.tracker.close();
    }

    public synchronized NotifyFuture<WriteResult> startWrite(Variant value, OperationParameters operationParameters, CallbackHandler callbackHandler) {
        if (this.connection == null) {
            return new InstantErrorFuture((Throwable)new IllegalStateException("No connection bound"));
        }
        return this.connection.getConnection().startWrite(this.item.getId(), value, operationParameters, callbackHandler);
    }

    public synchronized NotifyFuture<WriteAttributeResults> startWriteAttributes(Map<String, Variant> attributes, OperationParameters operationParameters, CallbackHandler callbackHandler) {
        if (this.connection == null) {
            return new InstantErrorFuture((Throwable)new IllegalStateException("No connection bound"));
        }
        return this.connection.getConnection().startWriteAttributes(this.item.getId(), attributes, operationParameters, callbackHandler);
    }

    public NotifyFuture<WriteResult> write(Variant value) {
        return this.write(value, null, null);
    }

    public synchronized NotifyFuture<WriteResult> write(Variant value, OperationParameters operationParameters, CallbackHandler callbackHandler) {
        if (this.connection == null) {
            return new InstantErrorFuture((Throwable)new IllegalStateException("No connection bound"));
        }
        return this.connection.getConnection().startWrite(this.item.getId(), value, operationParameters, callbackHandler);
    }

    public NotifyFuture<WriteAttributeResults> writeAtrtibutes(Map<String, Variant> attributes) {
        return this.writeAtrtibutes(attributes, null, null);
    }

    public synchronized NotifyFuture<WriteAttributeResults> writeAtrtibutes(Map<String, Variant> attributes, OperationParameters operationParameters, CallbackHandler callbackHandler) {
        if (this.connection == null) {
            return new InstantErrorFuture((Throwable)new IllegalStateException("No connection bound"));
        }
        return this.connection.getConnection().startWriteAttributes(this.item.getId(), attributes, operationParameters, callbackHandler);
    }

    public Item getItem() {
        return this.item;
    }

    public boolean waitForConnection(long timeout) throws InterruptedException {
        return this.tracker.waitForService(timeout) != null;
    }
}

