/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.client.test.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantType;
import org.eclipse.scada.da.ui.common.ValueType;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.da.ui.connection.data.ItemSelectionHelper;
import org.eclipse.scada.da.ui.widgets.realtime.AttributePair;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteAttributesOperationWizardValuePage
extends WizardPage
implements IWizardPage {
    private static final Logger logger = LoggerFactory.getLogger(WriteAttributesOperationWizardValuePage.class);
    private Text itemIdText;
    private TableViewer table;
    private ComboBoxCellEditor valueTypeEditor;
    private final String[] PROPERTIES = new String[]{"name", "value-type", "value", "value-error"};
    private final Attributes attributes = new Attributes();
    private final AddAction addAction = new AddAction();
    private final RemoveAction removeAction = new RemoveAction();
    private Item item;

    protected WriteAttributesOperationWizardValuePage() {
        super("wizardPage");
        this.setTitle("Write Attributes");
        this.setDescription("Configure the attributes to write");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Item:");
        this.itemIdText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.itemIdText.setLayoutData((Object)gd);
        this.itemIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WriteAttributesOperationWizardValuePage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        ToolBar toolbar = new ToolBar(container, 0);
        toolbar.setLayoutData((Object)gd);
        ToolBarManager tbm = new ToolBarManager(toolbar);
        tbm.add((IAction)this.addAction);
        tbm.add((IAction)this.removeAction);
        tbm.update(true);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.table = new TableViewer(container, 770);
        TableColumn col = new TableColumn(this.table.getTable(), 0);
        col.setText("Name");
        col = new TableColumn(this.table.getTable(), 0);
        col.setText("Value Type");
        col = new TableColumn(this.table.getTable(), 0);
        col.setText("Value");
        col = new TableColumn(this.table.getTable(), 0);
        col.setText("Value Error");
        this.table.getTable().setHeaderVisible(true);
        try {
            this.table.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
            this.table.setContentProvider((IContentProvider)new MyContentProvider());
            this.table.setColumnProperties(this.PROPERTIES);
            this.table.setCellModifier((ICellModifier)new MyCellModifier(this.table));
            TextCellEditor nameEditor = new TextCellEditor((Composite)this.table.getTable());
            LinkedList<String> values = new LinkedList<String>();
            ValueType[] valueTypeArray = ValueType.values();
            int n = valueTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ValueType vt = valueTypeArray[n2];
                values.add(vt.label());
                ++n2;
            }
            this.valueTypeEditor = new ComboBoxCellEditor((Composite)this.table.getTable(), values.toArray(new String[0]));
            TextCellEditor valueEditor = new TextCellEditor((Composite)this.table.getTable());
            this.table.setCellEditors(new CellEditor[]{nameEditor, this.valueTypeEditor, valueEditor, new TextCellEditor((Composite)this.table.getTable())});
            TableLayout tableLayout = new TableLayout();
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 75, true));
            this.table.getTable().setLayout((Layout)tableLayout);
            this.table.setInput((Object)this.attributes);
        }
        catch (Exception e) {
            logger.warn("Unable to create control", (Throwable)e);
        }
        this.table.getTable().setLayoutData((Object)gd);
        this.table.addSelectionChangedListener((ISelectionChangedListener)this.removeAction);
        this.setControl((Control)container);
        this.updateSelection();
        this.dialogChanged();
    }

    private void updateSelection() {
        this.itemIdText.setText(this.item.getId());
    }

    private void dialogChanged() {
        if (this.item == null) {
            this.updateStatus("No item selection");
            return;
        }
        if (this.itemIdText.getText().length() <= 0) {
            this.updateStatus("Item name must not be empty");
            return;
        }
        if (this.attributes.entries.size() <= 0) {
            this.updateStatus("No attributes");
            return;
        }
        for (AttributeEntry entry : this.attributes.entries) {
            if (!entry.name.equals("")) continue;
            this.updateStatus("Attribute with an empty name is not allowed");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public Item getItem() {
        return new Item(this.item.getConnectionString(), this.itemIdText.getText(), this.item.getType());
    }

    public Map<String, Variant> getAttributes() {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        for (AttributeEntry entry : this.attributes.entries) {
            attributes.put(entry.getName(), entry.getValue());
        }
        return attributes;
    }

    public void setSelection(IStructuredSelection selection) {
        this.item = ItemSelectionHelper.getFirstFromSelection((ISelection)selection);
        this.findAttributes(selection);
    }

    private void findAttributes(IStructuredSelection selection) {
        for (Object o : selection) {
            if (!(o instanceof AttributePair)) continue;
            AttributePair pair = (AttributePair)o;
            AttributeEntry entry = new AttributeEntry(pair.key, ValueType.fromVariantType((VariantType)pair.value.getType()), pair.value.asString(""));
            this.attributes.add(entry);
            if (this.table == null) continue;
            this.table.add((Object)entry);
        }
    }

    private class AddAction
    extends Action {
        public AddAction() {
            super("Add Entry", 1);
            this.setEnabled(true);
        }

        public void run() {
            AttributeEntry entry = new AttributeEntry("", ValueType.STRING, "");
            WriteAttributesOperationWizardValuePage.this.attributes.add(entry);
            WriteAttributesOperationWizardValuePage.this.table.add((Object)entry);
            WriteAttributesOperationWizardValuePage.this.dialogChanged();
        }
    }

    private class AttributeEntry {
        private String name = "";
        private ValueType valueType = ValueType.STRING;
        private String valueString = "";
        private Variant value = Variant.NULL;
        private Throwable valueError = null;

        public AttributeEntry(String name, ValueType valueType, String value) {
            this.name = name;
            this.valueType = valueType;
            this.setValue(value);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Variant getValue() {
            return this.value;
        }

        public String getValueString() {
            return this.valueString;
        }

        public void setValue(String value) {
            try {
                this.valueString = value;
                this.value = this.valueType.convertTo(value);
                this.valueError = null;
            }
            catch (Exception e) {
                this.valueError = e;
            }
        }

        public ValueType getValueType() {
            return this.valueType;
        }

        public void setValueType(ValueType valueType) {
            this.valueType = valueType;
            this.setValue(this.valueString);
        }

        public Throwable getValueError() {
            return this.valueError;
        }
    }

    private class Attributes {
        private final List<AttributeEntry> entries = new ArrayList<AttributeEntry>();

        private Attributes() {
        }

        public void add(AttributeEntry entry) {
            this.entries.add(entry);
        }

        public void remove(AttributeEntry entry) {
            this.entries.remove(entry);
        }

        public List<AttributeEntry> getEntries() {
            return this.entries;
        }
    }

    private class MyCellModifier
    implements ICellModifier {
        private TableViewer viewer = null;

        public MyCellModifier(TableViewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            logger.debug("Can modify: {}:{}", element, (Object)property);
            if (element instanceof AttributeEntry) {
                if (property.equals("value")) {
                    return true;
                }
                if (property.equals("name")) {
                    return true;
                }
                if (property.equals("value-type")) {
                    return true;
                }
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            logger.debug("Get Value: " + element + ":" + property);
            if (element instanceof AttributeEntry) {
                AttributeEntry entry = (AttributeEntry)element;
                if (property.equals("value")) {
                    return entry.getValueString();
                }
                if (property.equals("name")) {
                    return entry.getName();
                }
                if (property.equals("value-type")) {
                    return entry.getValueType().index();
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            logger.debug("Modify Value: {}:{}:{}", new Object[]{element, property, value});
            TableItem tableItem = (TableItem)element;
            if (tableItem.getData() instanceof AttributeEntry) {
                AttributeEntry entry = (AttributeEntry)tableItem.getData();
                if (property.equals("value")) {
                    entry.setValue(value.toString());
                } else if (property.equals("name")) {
                    entry.setName(value.toString());
                } else if (property.equals("value-type")) {
                    Integer i = (Integer)value;
                    String valueType = WriteAttributesOperationWizardValuePage.this.valueTypeEditor.getItems()[i];
                    ValueType[] valueTypeArray = ValueType.values();
                    int n = valueTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ValueType vt = valueTypeArray[n2];
                        if (vt.label().equals(valueType)) {
                            entry.setValueType(vt);
                        }
                        ++n2;
                    }
                }
                this.viewer.update((Object)entry, WriteAttributesOperationWizardValuePage.this.PROPERTIES);
                WriteAttributesOperationWizardValuePage.this.dialogChanged();
            }
        }
    }

    private class MyContentProvider
    implements IStructuredContentProvider {
        private MyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Attributes) {
                Attributes attributes = (Attributes)inputElement;
                return attributes.getEntries().toArray(new AttributeEntry[0]);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class MyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MyLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return this.getImage(element);
        }

        public String getColumnText(Object element, int columnIndex) {
            logger.debug("Label for: {} - {}", element, (Object)columnIndex);
            if (element instanceof AttributeEntry) {
                AttributeEntry entry = (AttributeEntry)element;
                logger.debug("Label: {}", (Object)entry.getName());
                switch (columnIndex) {
                    case 0: {
                        return entry.getName();
                    }
                    case 1: {
                        return entry.getValueType().toString();
                    }
                    case 2: {
                        return entry.getValue().asString("<null>");
                    }
                    case 3: {
                        if (entry.getValueError() != null) {
                            return entry.getValueError().getMessage();
                        }
                        return "";
                    }
                }
            }
            return this.getText(element);
        }
    }

    private class RemoveAction
    extends Action
    implements ISelectionChangedListener {
        private ISelection selection;

        public RemoveAction() {
            super("Remove Entry", 1);
        }

        public void run() {
            if (this.selection instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)this.selection;
                for (Object o : selection) {
                    if (!(o instanceof AttributeEntry)) continue;
                    WriteAttributesOperationWizardValuePage.this.attributes.remove((AttributeEntry)o);
                    WriteAttributesOperationWizardValuePage.this.table.remove(o);
                }
                WriteAttributesOperationWizardValuePage.this.dialogChanged();
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.selection = event.getSelection();
        }
    }
}

