/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.client.test.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.ui.client.test.Activator;
import org.eclipse.scada.da.ui.client.test.wizards.WriteOperationWizardValuePage;
import org.eclipse.scada.da.ui.connection.data.DataItemHolder;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.ui.DisplayCallbackHandler;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteOperationWizard
extends Wizard
implements INewWizard {
    private static final Logger logger = LoggerFactory.getLogger(WriteOperationWizard.class);
    private WriteOperationWizardValuePage page = null;
    private IStructuredSelection selection = null;

    public WriteOperationWizard() {
        this.setWindowTitle("Write to data item");
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        final Item item = this.page.getItem();
        final Variant value = this.page.getValue();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        WriteOperationWizard.this.doFinish(monitor, item, value);
                    }
                    catch (Throwable e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            logger.warn("Failed to perform write operation", (Throwable)e);
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error writing to item", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(IProgressMonitor monitor, Item item, Variant value) throws Exception {
        monitor.beginTask("Writing value to item", 2);
        monitor.worked(1);
        try {
            DataItemHolder itemHolder = new DataItemHolder(Activator.getDefault().getBundle().getBundleContext(), item, null);
            if (!itemHolder.waitForConnection(5000L)) {
                this.handleError(new RuntimeException("No available connection").fillInStackTrace());
                return;
            }
            NotifyFuture future = itemHolder.startWrite(value, null, (CallbackHandler)new DisplayCallbackHandler(this.getShell(), "Write operation", "Write operation"));
            try {
                future.get();
            }
            catch (Throwable e) {
                this.handleError(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void handleError(final Throwable e) {
        logger.warn("Failed to write", e);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)WriteOperationWizard.this.getShell(), (String)"Failed to write", (String)"Failed to write to the data item", (IStatus)new Status(4, "org.eclipse.scada.da.ui.client.test", e.getMessage(), e));
            }
        });
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        this.selection = selection;
    }

    public void addPages() {
        super.addPages();
        this.page = new WriteOperationWizardValuePage();
        this.addPage(this.page);
        this.page.setSelection(this.selection);
    }
}

