/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.viewer.ext.item;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.ui.databinding.item.DataItemObservableValue;
import org.eclipse.scada.vi.ui.viewer.ext.Activator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class DataItemLabel {
    protected final CLabel label;
    protected final DataItemObservableValue dataItem;
    protected final DataBindingContext dbc;
    protected final IObservableValue model;

    public DataItemLabel(Composite composite, String connectionId, String itemId) {
        this.label = new CLabel(composite, 0);
        this.dataItem = new DataItemObservableValue(Activator.getDefault().getBundle().getBundleContext(), connectionId, itemId);
        this.label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DataItemLabel.this.handleDispose();
            }
        });
        this.model = PojoObservables.observeDetailValue((IObservableValue)this.dataItem, (String)"value", Variant.class);
        this.dbc = new DataBindingContext();
        this.bind();
    }

    protected abstract void bind();

    protected void handleDispose() {
        this.dbc.dispose();
        this.model.dispose();
        this.dataItem.dispose();
    }

    public Control getControl() {
        return this.label;
    }
}

