/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.model.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.scada.ui.chart.model.ArchiveChannel;
import org.eclipse.scada.ui.chart.model.ArchiveSeries;
import org.eclipse.scada.ui.chart.model.Chart;
import org.eclipse.scada.ui.chart.model.ChartFactory;
import org.eclipse.scada.ui.chart.model.ChartPackage;
import org.eclipse.scada.ui.chart.model.CompositeArchiveQualitySeries;
import org.eclipse.scada.ui.chart.model.CurrentTimeController;
import org.eclipse.scada.ui.chart.model.DataItemSeries;
import org.eclipse.scada.ui.chart.model.IdItem;
import org.eclipse.scada.ui.chart.model.LineProperties;
import org.eclipse.scada.ui.chart.model.MouseController;
import org.eclipse.scada.ui.chart.model.Profile;
import org.eclipse.scada.ui.chart.model.ProfileSwitcherType;
import org.eclipse.scada.ui.chart.model.ResetController;
import org.eclipse.scada.ui.chart.model.ScaleAction;
import org.eclipse.scada.ui.chart.model.ScriptSeries;
import org.eclipse.scada.ui.chart.model.SeparatorController;
import org.eclipse.scada.ui.chart.model.TimeNowAction;
import org.eclipse.scada.ui.chart.model.TimeShiftAction;
import org.eclipse.scada.ui.chart.model.UriItem;
import org.eclipse.scada.ui.chart.model.XAxis;
import org.eclipse.scada.ui.chart.model.YAxis;
import org.eclipse.scada.ui.chart.model.impl.ArchiveChannelImpl;
import org.eclipse.scada.ui.chart.model.impl.ArchiveSeriesImpl;
import org.eclipse.scada.ui.chart.model.impl.ChartImpl;
import org.eclipse.scada.ui.chart.model.impl.CompositeArchiveQualitySeriesImpl;
import org.eclipse.scada.ui.chart.model.impl.CurrentTimeControllerImpl;
import org.eclipse.scada.ui.chart.model.impl.DataItemSeriesImpl;
import org.eclipse.scada.ui.chart.model.impl.IdItemImpl;
import org.eclipse.scada.ui.chart.model.impl.LinePropertiesImpl;
import org.eclipse.scada.ui.chart.model.impl.MouseControllerImpl;
import org.eclipse.scada.ui.chart.model.impl.ProfileImpl;
import org.eclipse.scada.ui.chart.model.impl.ResetControllerImpl;
import org.eclipse.scada.ui.chart.model.impl.ScaleActionImpl;
import org.eclipse.scada.ui.chart.model.impl.ScriptSeriesImpl;
import org.eclipse.scada.ui.chart.model.impl.SeparatorControllerImpl;
import org.eclipse.scada.ui.chart.model.impl.TimeNowActionImpl;
import org.eclipse.scada.ui.chart.model.impl.TimeShiftActionImpl;
import org.eclipse.scada.ui.chart.model.impl.UriItemImpl;
import org.eclipse.scada.ui.chart.model.impl.XAxisImpl;
import org.eclipse.scada.ui.chart.model.impl.YAxisImpl;
import org.eclipse.swt.graphics.RGB;

public class ChartFactoryImpl
extends EFactoryImpl
implements ChartFactory {
    public static ChartFactory init() {
        try {
            ChartFactory theChartFactory = (ChartFactory)EPackage.Registry.INSTANCE.getEFactory("http://eclipse.org/SCADA/UI/Chart");
            if (theChartFactory != null) {
                return theChartFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ChartFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createChart();
            }
            case 1: {
                return this.createXAxis();
            }
            case 2: {
                return this.createYAxis();
            }
            case 5: {
                return this.createDataItemSeries();
            }
            case 6: {
                return this.createArchiveSeries();
            }
            case 8: {
                return this.createUriItem();
            }
            case 9: {
                return this.createIdItem();
            }
            case 11: {
                return this.createArchiveChannel();
            }
            case 12: {
                return this.createLineProperties();
            }
            case 13: {
                return this.createScriptSeries();
            }
            case 15: {
                return this.createCurrentTimeController();
            }
            case 16: {
                return this.createProfile();
            }
            case 17: {
                return this.createTimeShiftAction();
            }
            case 18: {
                return this.createTimeNowAction();
            }
            case 20: {
                return this.createScaleAction();
            }
            case 21: {
                return this.createSeparatorController();
            }
            case 22: {
                return this.createMouseController();
            }
            case 23: {
                return this.createResetController();
            }
            case 24: {
                return this.createCompositeArchiveQualitySeries();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 25: {
                return this.createProfileSwitcherTypeFromString(eDataType, initialValue);
            }
            case 26: {
                return this.createRGBFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 25: {
                return this.convertProfileSwitcherTypeToString(eDataType, instanceValue);
            }
            case 26: {
                return this.convertRGBToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Chart createChart() {
        ChartImpl chart = new ChartImpl();
        return chart;
    }

    @Override
    public XAxis createXAxis() {
        XAxisImpl xAxis = new XAxisImpl();
        return xAxis;
    }

    @Override
    public YAxis createYAxis() {
        YAxisImpl yAxis = new YAxisImpl();
        return yAxis;
    }

    @Override
    public DataItemSeries createDataItemSeries() {
        DataItemSeriesImpl dataItemSeries = new DataItemSeriesImpl();
        return dataItemSeries;
    }

    @Override
    public ArchiveSeries createArchiveSeries() {
        ArchiveSeriesImpl archiveSeries = new ArchiveSeriesImpl();
        return archiveSeries;
    }

    @Override
    public UriItem createUriItem() {
        UriItemImpl uriItem = new UriItemImpl();
        return uriItem;
    }

    @Override
    public IdItem createIdItem() {
        IdItemImpl idItem = new IdItemImpl();
        return idItem;
    }

    @Override
    public ArchiveChannel createArchiveChannel() {
        ArchiveChannelImpl archiveChannel = new ArchiveChannelImpl();
        return archiveChannel;
    }

    @Override
    public LineProperties createLineProperties() {
        LinePropertiesImpl lineProperties = new LinePropertiesImpl();
        return lineProperties;
    }

    @Override
    public ScriptSeries createScriptSeries() {
        ScriptSeriesImpl scriptSeries = new ScriptSeriesImpl();
        return scriptSeries;
    }

    @Override
    public CurrentTimeController createCurrentTimeController() {
        CurrentTimeControllerImpl currentTimeController = new CurrentTimeControllerImpl();
        return currentTimeController;
    }

    @Override
    public Profile createProfile() {
        ProfileImpl profile = new ProfileImpl();
        return profile;
    }

    @Override
    public TimeShiftAction createTimeShiftAction() {
        TimeShiftActionImpl timeShiftAction = new TimeShiftActionImpl();
        return timeShiftAction;
    }

    @Override
    public TimeNowAction createTimeNowAction() {
        TimeNowActionImpl timeNowAction = new TimeNowActionImpl();
        return timeNowAction;
    }

    @Override
    public ScaleAction createScaleAction() {
        ScaleActionImpl scaleAction = new ScaleActionImpl();
        return scaleAction;
    }

    @Override
    public SeparatorController createSeparatorController() {
        SeparatorControllerImpl separatorController = new SeparatorControllerImpl();
        return separatorController;
    }

    @Override
    public MouseController createMouseController() {
        MouseControllerImpl mouseController = new MouseControllerImpl();
        return mouseController;
    }

    @Override
    public ResetController createResetController() {
        ResetControllerImpl resetController = new ResetControllerImpl();
        return resetController;
    }

    @Override
    public CompositeArchiveQualitySeries createCompositeArchiveQualitySeries() {
        CompositeArchiveQualitySeriesImpl compositeArchiveQualitySeries = new CompositeArchiveQualitySeriesImpl();
        return compositeArchiveQualitySeries;
    }

    public ProfileSwitcherType createProfileSwitcherTypeFromString(EDataType eDataType, String initialValue) {
        ProfileSwitcherType result = ProfileSwitcherType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertProfileSwitcherTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public RGB createRGBFromString(EDataType eDataType, String initialValue) {
        Pattern p = Pattern.compile("#([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})");
        Matcher m = p.matcher(initialValue);
        if (!m.matches()) {
            throw new IllegalArgumentException("RGB syntax is #RRGGBB in hex");
        }
        int red = Integer.parseInt(m.group(1), 16);
        int green = Integer.parseInt(m.group(2), 16);
        int blue = Integer.parseInt(m.group(3), 16);
        return new RGB(red, green, blue);
    }

    public String convertRGBToString(EDataType eDataType, Object instanceValue) {
        RGB rgb = (RGB)instanceValue;
        if (rgb == null) {
            return null;
        }
        return String.format("#%02X%02X%02X", rgb.red, rgb.green, rgb.blue);
    }

    @Override
    public ChartPackage getChartPackage() {
        return (ChartPackage)this.getEPackage();
    }

    @Deprecated
    public static ChartPackage getPackage() {
        return ChartPackage.eINSTANCE;
    }
}

