/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.styles;

import org.eclipse.scada.core.ui.styles.StyleHandler;
import org.eclipse.scada.ui.blink.AbstractBlinker;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public abstract class StyleBlinker
extends AbstractBlinker
implements StyleHandler {
    private int counter;
    private StyleHandler.Style style;

    @Override
    public void setStyle(final StyleHandler.Style style) {
        final Display display = Display.getDefault();
        if (display.isDisposed()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                StyleBlinker.this.performSetStyle(style);
            }
        });
    }

    private void performSetStyle(StyleHandler.Style style) {
        this.style = style;
        this.applyState();
        if (this.needBlink(style)) {
            this.enableBlinking(true);
        } else {
            this.enableBlinking(false);
        }
    }

    protected boolean needBlink(StyleHandler.Style style) {
        if (style == null) {
            return false;
        }
        if (style.backgroundColor != null && style.backgroundColor.length > 1) {
            return true;
        }
        if (style.images != null && style.images.length > 1) {
            return true;
        }
        if (style.foregroundColor != null && style.foregroundColor.length > 1) {
            return true;
        }
        return style.font != null && style.font.length > 1;
    }

    public void toggle(int globalCounter) {
        this.counter = globalCounter;
        this.applyState();
    }

    private void applyState() {
        if (this.style == null) {
            this.update(CurrentStyle.EMPTY);
            return;
        }
        Image image = this.style.images == null || this.style.images.length == 0 ? null : this.style.images[this.counter % this.style.images.length];
        Color foreground = this.style.foregroundColor == null || this.style.foregroundColor.length == 0 ? null : this.style.foregroundColor[this.counter % this.style.foregroundColor.length];
        Color background = this.style.backgroundColor == null || this.style.backgroundColor.length == 0 ? null : this.style.backgroundColor[this.counter % this.style.backgroundColor.length];
        Font font = this.style.font == null || this.style.font.length == 0 ? null : this.style.font[this.counter % this.style.font.length];
        this.update(new CurrentStyle(image, foreground, background, font));
    }

    public abstract void update(CurrentStyle var1);

    public static class CurrentStyle {
        public static final CurrentStyle EMPTY = new CurrentStyle();
        public final Image image;
        public final Color foreground;
        public final Color background;
        public final Font font;

        private CurrentStyle() {
            this.image = null;
            this.foreground = null;
            this.background = null;
            this.font = null;
        }

        public CurrentStyle(Image image, Color foreground, Color background, Font font) {
            this.image = image;
            this.foreground = foreground;
            this.background = background;
            this.font = font;
        }
    }
}

