/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.styles;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class StyleGeneratorInformation {
    private static final String EXTP_STYLE_GENERATOR = "org.eclipse.scada.core.ui.styles.styleGenerator";
    private static final String ELE_STYLE_GENERATOR = "styleGenerator";
    private final String id;
    private final String name;
    private final String description;

    public StyleGeneratorInformation(String id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static List<StyleGeneratorInformation> list() {
        LinkedList<StyleGeneratorInformation> result = new LinkedList<StyleGeneratorInformation>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_STYLE_GENERATOR);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            if (ELE_STYLE_GENERATOR.equals(ele.getName())) {
                String id = ele.getAttribute("id");
                String name = ele.getAttribute("name");
                String description = StyleGeneratorInformation.getText(ele.getChildren("description"));
                result.add(new StyleGeneratorInformation(id, name, description));
            }
            ++n2;
        }
        return result;
    }

    private static String getText(IConfigurationElement[] children) {
        if (children == null) {
            return null;
        }
        IConfigurationElement[] iConfigurationElementArray = children;
        if (children.length != 0) {
            IConfigurationElement ele = iConfigurationElementArray[0];
            return ele.getValue();
        }
        return null;
    }

    public static IConfigurationElement getConfiguration(String generatorId) {
        if (generatorId == null) {
            return null;
        }
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_STYLE_GENERATOR);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IConfigurationElement ele = iConfigurationElementArray[n2];
            if (ELE_STYLE_GENERATOR.equals(ele.getName()) && (id = ele.getAttribute("id")) != null && id.equals(generatorId)) {
                return ele;
            }
            ++n2;
        }
        return null;
    }
}

