/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.styles.preferences;

import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.scada.core.ui.styles.Activator;
import org.eclipse.scada.core.ui.styles.StyleGeneratorInformation;
import org.eclipse.scada.core.ui.styles.preferences.ComboFieldEditor2;
import org.eclipse.scada.core.ui.styles.preferences.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class StylePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Text descriptionArea;
    private HashMap<String, String> descriptionMap;

    public StylePreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.StylePreferencePage_Description);
    }

    public void createFieldEditors() {
        String[][] entryNamesAndValues = this.makeNamesAndValues();
        ComboFieldEditor2 generatorEditor = new ComboFieldEditor2("styleGeneratorId", Messages.StylePreferencePage_Label, entryNamesAndValues, this.getFieldEditorParent());
        generatorEditor.setCallback(new ComboFieldEditor2.Callback(){

            @Override
            public void valueChange(Object value) {
                if (value instanceof String) {
                    StylePreferencePage.this.setGeneratorDescription((String)value);
                }
            }
        });
        this.addField((FieldEditor)generatorEditor);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.refresh();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.refresh();
    }

    private void refresh() {
        this.setGeneratorDescription(this.getPreferenceStore().getString("styleGeneratorId"));
    }

    private void setGeneratorDescription(String generatorId) {
        String description = this.descriptionMap.get(generatorId);
        if (description != null) {
            this.descriptionArea.setText(description);
        } else {
            this.descriptionArea.setText("");
        }
    }

    protected Control createContents(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new GridLayout(1, false));
        Control control = super.createContents(wrapper);
        control.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createDescription(wrapper);
        return wrapper;
    }

    private void createDescription(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.StylePreferencePage_Description_Label);
        this.descriptionArea = new Text(parent, 2122);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 300;
        this.descriptionArea.setLayoutData((Object)gd);
    }

    private String[][] makeNamesAndValues() {
        this.descriptionMap = new HashMap();
        LinkedList<String[]> names = new LinkedList<String[]>();
        for (StyleGeneratorInformation info : StyleGeneratorInformation.list()) {
            names.add(new String[]{info.getName(), info.getId()});
            this.descriptionMap.put(info.getId(), info.getDescription());
        }
        return (String[][])names.toArray((T[])new String[names.size()][]);
    }

    public void init(IWorkbench workbench) {
    }
}

