/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.view;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.scada.chart.swt.ChartArea;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.chart.swt.SWTGraphics;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.ui.chart.model.Chart;
import org.eclipse.scada.ui.chart.model.ChartPackage;
import org.eclipse.scada.ui.chart.viewer.ChartViewer;
import org.eclipse.scada.ui.chart.viewer.CompositeExtensionSpace;
import org.eclipse.scada.ui.chart.viewer.ExtensionSpaceProvider;
import org.eclipse.scada.ui.chart.viewer.input.ChartInput;
import org.eclipse.scada.ui.databinding.SelectionHelper;
import org.eclipse.scada.ui.utils.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractChartView
extends ViewPart {
    protected ChartViewer viewer;
    private ChartArea chartArea;
    private Shell shell;
    private Composite wrapper;

    protected static Chart load(InputStream input) throws IOException {
        Resource resource = new XMIResourceFactoryImpl().createResource(URI.createURI((String)"urn:memento"));
        HashMap options = new HashMap();
        resource.load(input, options);
        return (Chart)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)ChartPackage.Literals.CHART);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.wrapper = new Composite(parent, 0);
        this.wrapper.setLayout((Layout)GridLayoutFactory.slimStack());
        this.shell = parent.getShell();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.wrapper, "org.eclipse.scada.ui.chart.view.chartView");
        this.fillMenu((IContributionManager)this.getViewSite().getActionBars().getMenuManager());
        this.fillToolbar((IContributionManager)this.getViewSite().getActionBars().getToolBarManager());
        this.createChartControl(parent);
    }

    protected abstract void createChartControl(Composite var1);

    protected void createView(Chart configuration) {
        Composite extensionSpace = new Composite(this.wrapper, 0);
        extensionSpace.setLayoutData((Object)new GridData(4, 4, true, false));
        extensionSpace.setLayout((Layout)new RowLayout(256));
        this.chartArea = new ChartArea(this.wrapper, 0);
        this.chartArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new ChartViewer(this.chartArea.getChartRenderer(), configuration, (ExtensionSpaceProvider)new CompositeExtensionSpace(extensionSpace), null);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                Object sel = SelectionHelper.first((ISelection)selection, Object.class);
                if (sel == null) {
                    AbstractChartView.this.viewer.setSelection(null);
                } else if (sel instanceof ChartInput) {
                    AbstractChartView.this.viewer.setSelection((ChartInput)sel);
                }
            }
        });
    }

    private void fillMenu(IContributionManager contributionManager) {
        contributionManager.add((IAction)new PrintAction());
        contributionManager.add((IAction)new ControllerAction());
    }

    private void fillToolbar(IContributionManager contributionManager) {
        contributionManager.add((IAction)new SetTimespanAction(1L, TimeUnit.MINUTES, "<1m>", "Scale to one minute"));
        contributionManager.add((IAction)new SetTimespanAction(1L, TimeUnit.HOURS, "<1h>", "Scale to one hour"));
        contributionManager.add((IAction)new SetTimespanAction(1L, TimeUnit.DAYS, "<1d>", "Scale to one day"));
        contributionManager.add((IAction)new CenterNowAction());
        contributionManager.add((IContributionItem)new Separator());
        contributionManager.add((IAction)new PageTimespanAction(-1L, TimeUnit.DAYS, "<1d", "Move back 1 day"));
        contributionManager.add((IAction)new PageTimespanAction(-1L, TimeUnit.HOURS, "<1h", "Move back 1 hour"));
        contributionManager.add((IAction)new PageTimespanAction(-1L, TimeUnit.MINUTES, "<1m", "Move back 1 minute"));
        contributionManager.add((IContributionItem)new Separator());
        contributionManager.add((IAction)new PageTimespanAction(1L, TimeUnit.MINUTES, "1m>", "Move forward 1 minute"));
        contributionManager.add((IAction)new PageTimespanAction(1L, TimeUnit.HOURS, "1h>", "Move forward 1 hour"));
        contributionManager.add((IAction)new PageTimespanAction(1L, TimeUnit.DAYS, "1d>", "Move forward 1 day"));
        contributionManager.add((IContributionItem)new Separator());
        contributionManager.add((IAction)new HelpAction());
    }

    public void dispose() {
        if (this.viewer != null) {
            this.viewer.dispose();
        }
        super.dispose();
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }

    public void print() {
        if (Printer.getPrinterList().length == 0) {
            MessageDialog.openInformation((Shell)this.shell, (String)"No printer", (String)"No installed printer could be found");
            return;
        }
        PrintDialog dlg = new PrintDialog(this.shell, 65536);
        PrinterData initialPd = Printer.getDefaultPrinterData();
        initialPd.orientation = 2;
        dlg.setPrinterData(initialPd);
        PrinterData pd = dlg.open();
        if (pd != null) {
            Printer printer = new Printer(pd);
            try {
                printer.startJob("Chart");
                printer.startPage();
                GC gc = new GC((Drawable)printer);
                try {
                    this.viewer.getChartRenderer().paint((Graphics)new SWTGraphics(gc));
                }
                finally {
                    gc.dispose();
                }
                printer.endPage();
                printer.endJob();
            }
            finally {
                printer.dispose();
            }
        }
    }

    public void showTimespan(long duration, TimeUnit timeUnit) {
        this.viewer.showTimespan(duration, timeUnit);
    }

    public void pageTimespan(long duration, TimeUnit timeUnit) {
        this.viewer.pageTimespan(duration, timeUnit);
    }

    public void addItem(Item item) {
        this.viewer.addItem(item);
    }

    public void addItem(org.eclipse.scada.hd.ui.connection.data.Item item) {
        this.viewer.addItem(item);
    }

    public class CenterNowAction
    extends Action {
        public CenterNowAction() {
            super("<now>");
            this.setDescription("Center chart to current time");
            this.setToolTipText("Center chart to current time");
        }

        public void run() {
            AbstractChartView.this.viewer.setNowCenter();
        }
    }

    public class ControllerAction
    extends Action {
        public ControllerAction() {
            super("Show controller", AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.scada.ui.chart.view", (String)"icons/chartController.gif"));
            this.setDescription("Show the chart controller view");
            this.setToolTipText("Show the chart controller view");
        }

        public void run() {
            try {
                AbstractChartView.this.getViewSite().getWorkbenchWindow().getActivePage().showView("org.eclipse.scada.ui.chart.ChartController");
            }
            catch (PartInitException e) {
                StatusManager.getManager().handle(e.getStatus(), 4);
            }
        }
    }

    public class HelpAction
    extends Action {
        public HelpAction() {
            super("Help", AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.scada.ui.chart.view", (String)"icons/help.gif"));
        }

        public void run() {
            PlatformUI.getWorkbench().getHelpSystem().displayDynamicHelp();
        }
    }

    class PageTimespanAction
    extends TimeAction {
        public PageTimespanAction(long duration, TimeUnit timeUnit, String label, String description) {
            super(duration, timeUnit, label, description);
        }

        public void run() {
            AbstractChartView.this.pageTimespan(this.duration, this.timeUnit);
        }
    }

    public class PrintAction
    extends Action {
        public PrintAction() {
            super("Print\u2026", AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.scada.ui.chart.view", (String)"icons/print.gif"));
            this.setDescription("Print the current chart view");
            this.setToolTipText("Print the current chart view");
        }

        public void run() {
            AbstractChartView.this.print();
        }
    }

    class SetTimespanAction
    extends TimeAction {
        public SetTimespanAction(long duration, TimeUnit timeUnit, String label, String description) {
            super(duration, timeUnit, label, description);
        }

        public void run() {
            AbstractChartView.this.showTimespan(this.duration, this.timeUnit);
        }
    }

    private class TimeAction
    extends Action {
        protected final long duration;
        protected final TimeUnit timeUnit;

        public TimeAction(long duration, TimeUnit timeUnit, String label, String description) {
            super(label);
            this.setDescription(description);
            this.setToolTipText(description);
            this.duration = duration;
            this.timeUnit = timeUnit;
        }
    }
}

