/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scada.ui.chart.model.Chart;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.statushandlers.StatusManager;

public class ChartActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IViewPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action("Show &Properties View"){

        public void run() {
            try {
                ChartActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                StatusManager.getManager().handle(exception.getStatus(), 1);
            }
        }
    };
    protected SaveAsAction saveAsAction = new SaveAsAction();
    protected IAction refreshViewerAction = new Action("&Refresh"){

        public boolean isEnabled() {
            return ChartActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (ChartActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)ChartActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected Collection<IAction> createChildActions;
    protected IMenuManager createChildMenuManager;
    protected Collection<IAction> createSiblingActions;
    protected IMenuManager createSiblingMenuManager;

    public ChartActionBarContributor() {
        super(1);
        this.loadResourceAction = new LoadResourceAction();
        this.validateAction = new ValidateAction();
        this.controlAction = new ControlAction();
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("chart-settings"));
        toolBarManager.add((IContributionItem)new Separator("chart-additions"));
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager("&Chart Editor", "org.eclipse.scada.ui.chart.model.model.ChartModelMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager("&New Child");
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager("N&ew Sibling");
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    public void setViewPart(IViewPart part) {
        if (part != this.activeEditorPart) {
            if (this.activeEditorPart != null) {
                this.deactivate();
            }
            if (part instanceof IEditingDomainProvider) {
                this.activeEditorPart = part;
                this.activate();
            }
        }
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            this.deleteAction.setActiveWorkbenchPart((IWorkbenchPart)part);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateChildAction((IWorkbenchPart)this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction((IWorkbenchPart)this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = null;
        submenuManager = new MenuManager("&New Child");
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager("N&ew Sibling");
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        menuManager.insertAfter("ui-actions", (IAction)this.saveAsAction);
        super.addGlobalActions(menuManager);
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }

    public void deactivate() {
        ISelectionProvider selectionProvider;
        this.activeEditor.removePropertyListener((IPropertyListener)this);
        this.deleteAction.setActiveWorkbenchPart(null);
        this.cutAction.setActiveWorkbenchPart(null);
        this.copyAction.setActiveWorkbenchPart(null);
        this.pasteAction.setActiveWorkbenchPart(null);
        this.undoAction.setActiveWorkbenchPart(null);
        this.redoAction.setActiveWorkbenchPart(null);
        if (this.loadResourceAction != null) {
            this.loadResourceAction.setActiveWorkbenchPart(null);
        }
        if (this.controlAction != null) {
            this.controlAction.setActiveWorkbenchPart(null);
        }
        if (this.validateAction != null) {
            this.validateAction.setActiveWorkbenchPart(null);
        }
        ISelectionProvider iSelectionProvider = selectionProvider = this.activeEditorPart instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditorPart : this.activeEditorPart.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.cutAction);
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.copyAction);
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
            if (this.validateAction != null) {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.validateAction);
            }
            if (this.controlAction != null) {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.controlAction);
            }
            if (this.saveAsAction != null) {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.saveAsAction);
            }
        }
    }

    public void activate() {
        ISelectionProvider selectionProvider;
        this.activeEditorPart.addPropertyListener((IPropertyListener)this);
        this.deleteAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditorPart);
        this.cutAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditorPart);
        this.copyAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditorPart);
        this.pasteAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditorPart);
        this.undoAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditorPart);
        this.redoAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditorPart);
        if (this.loadResourceAction != null) {
            this.loadResourceAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditorPart);
        }
        if (this.controlAction != null) {
            this.controlAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditorPart);
        }
        if (this.validateAction != null) {
            this.validateAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditorPart);
        }
        ISelectionProvider iSelectionProvider = selectionProvider = this.activeEditorPart instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditorPart : this.activeEditorPart.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.cutAction);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.copyAction);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
            if (this.validateAction != null) {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.validateAction);
            }
            if (this.controlAction != null) {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.controlAction);
            }
            if (this.saveAsAction != null) {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.saveAsAction);
            }
        }
        this.update();
    }

    public void update() {
        ISelectionProvider selectionProvider;
        ISelectionProvider iSelectionProvider = selectionProvider = this.activeEditorPart instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditorPart : this.activeEditorPart.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            ISelection selection = selectionProvider.getSelection();
            StructuredSelection structuredSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
            this.deleteAction.updateSelection((IStructuredSelection)structuredSelection);
            this.cutAction.updateSelection((IStructuredSelection)structuredSelection);
            this.copyAction.updateSelection((IStructuredSelection)structuredSelection);
            this.pasteAction.updateSelection((IStructuredSelection)structuredSelection);
            if (this.validateAction != null) {
                this.validateAction.updateSelection((IStructuredSelection)structuredSelection);
            }
            if (this.controlAction != null) {
                this.controlAction.updateSelection((IStructuredSelection)structuredSelection);
            }
            if (this.saveAsAction != null) {
                this.saveAsAction.selectionChanged((IStructuredSelection)structuredSelection);
            }
        }
        this.undoAction.update();
        this.redoAction.update();
        if (this.loadResourceAction != null) {
            this.loadResourceAction.update();
        }
    }

    public static class SaveAsAction
    extends BaseSelectionListenerAction {
        private Chart chart;

        public SaveAsAction() {
            super("Save as\u2026");
        }

        public void run() {
            if (this.chart == null) {
                return;
            }
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            FileDialog dlg = new FileDialog(shell, 8192);
            dlg.setFilterExtensions(new String[]{"*.chart"});
            dlg.setFilterNames(new String[]{"Eclipse SCADA Chart Configuration"});
            dlg.setOverwrite(true);
            dlg.setText("Select the file to store the chart configurationt to");
            final String file = dlg.open();
            if (file != null) {
                new Job("Perform save"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            try {
                                SaveAsAction.this.doSave(file);
                            }
                            catch (IOException e) {
                                IStatus iStatus = StatusHelper.convertStatus((String)"org.eclipse.scada.ui.chart.view", (Throwable)e);
                                monitor.done();
                                return iStatus;
                            }
                        }
                        finally {
                            monitor.done();
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }

        private void doSave(String file) throws IOException {
            ResourceSetImpl rs = new ResourceSetImpl();
            rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMLResourceFactoryImpl());
            URI fileUri = URI.createFileURI((String)file);
            Resource resource = rs.createResource(fileUri);
            resource.getContents().add((Object)this.chart);
            HashMap options = new HashMap();
            resource.save(options);
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            this.chart = null;
            if (selection.isEmpty()) {
                return false;
            }
            Object o = selection.getFirstElement();
            if (!(o instanceof Chart)) {
                return false;
            }
            this.chart = (Chart)o;
            return true;
        }
    }
}

