/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.dataitem.details;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.scada.core.ui.styles.StateInformation;
import org.eclipse.scada.core.ui.styles.StateStyler;
import org.eclipse.scada.core.ui.styles.StyleBlinker;
import org.eclipse.scada.core.ui.styles.StyleHandler;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.client.dataitem.details.Activator;
import org.eclipse.scada.da.client.dataitem.details.CTabVisibilityController;
import org.eclipse.scada.da.client.dataitem.details.DetailsPartInformation;
import org.eclipse.scada.da.client.dataitem.details.Messages;
import org.eclipse.scada.da.client.dataitem.details.part.DetailsPart;
import org.eclipse.scada.da.ui.connection.data.DataItemHolder;
import org.eclipse.scada.da.ui.connection.data.DataSourceListener;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.da.ui.styles.DataItemValueStateExtractor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DetailsViewComposite
extends Composite {
    private final Collection<DetailsPart> detailParts = new LinkedList<DetailsPart>();
    private DataItemHolder dataItem;
    private CTabFolder tabFolder;
    private Label headerIcon;
    private Label headerLabel;
    private Composite header;
    private Label headerValueLabel;
    private final LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private final Display display;
    private StyleBlinker blinker;
    private StateStyler styler;

    public DetailsViewComposite(Composite parent, int style) {
        super(parent, style);
        this.display = parent.getDisplay();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DetailsViewComposite.this.handleDispose();
            }
        });
        this.createControls(parent);
    }

    private void createControls(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.createHeader(this);
        this.tabFolder = new CTabFolder((Composite)this, 0x800400);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        try {
            for (final DetailsPartInformation info : this.getPartInformation()) {
                CTabVisibilityController controller = new CTabVisibilityController(this.tabFolder, info.getLabel()){

                    @Override
                    protected Control createPart(Composite parent) {
                        Composite parentComposite = new Composite(parent, 0);
                        parentComposite.setLayout((Layout)new FillLayout());
                        try {
                            info.getDetailsPart().createPart(parentComposite);
                        }
                        catch (Exception e) {
                            Text text = new Text(parentComposite, 10);
                            StringWriter sw = new StringWriter();
                            e.printStackTrace(new PrintWriter(sw));
                            text.setText(sw.toString());
                        }
                        return parentComposite;
                    }
                };
                controller.create();
                info.getDetailsPart().setVisibilityController(controller);
                this.detailParts.add(info.getDetailsPart());
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        if (!this.detailParts.isEmpty()) {
            this.tabFolder.setSelection(0);
        }
    }

    private Collection<DetailsPartInformation> getPartInformation() throws CoreException {
        LinkedList<DetailsPartInformation> result = new LinkedList<DetailsPartInformation>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.scada.da.client.dataitem.details.DetailsViewPart");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("detailsPart".equals(element.getName())) {
                Object o = element.createExecutableExtension("class");
                if (!(o instanceof DetailsPart)) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.scada.da.client.dataitem.details", "DetailsPart is not of type 'DetailsPart'"));
                }
                DetailsPartInformation info = new DetailsPartInformation();
                info.setDetailsPart((DetailsPart)o);
                info.setLabel(element.getAttribute("name"));
                info.setSortKey(element.getAttribute("sortKey"));
                result.add(info);
            }
            ++n2;
        }
        Collections.sort(result, new Comparator<DetailsPartInformation>(){

            @Override
            public int compare(DetailsPartInformation arg0, DetailsPartInformation arg1) {
                String key1 = arg0.getSortKey();
                String key2 = arg1.getSortKey();
                if (key1 == null) {
                    key1 = "";
                }
                if (key2 == null) {
                    key2 = "";
                }
                return key1.compareTo(key2);
            }
        });
        return result;
    }

    private void createHeader(Composite parent) {
        this.header = new Composite(parent, 0);
        this.header.setLayoutData((Object)new GridData(4, 1, true, false));
        this.header.setLayout((Layout)new RowLayout(256));
        this.headerIcon = new Label(this.header, 0);
        this.headerLabel = new Label(this.header, 0);
        this.headerLabel.setText(Messages.DetailsViewComposite_EmptyDataItem);
        this.headerValueLabel = new Label(this.header, 0);
        this.blinker = new StyleBlinker(){

            public void update(StyleBlinker.CurrentStyle style) {
                DetailsViewComposite.this.handleStyleUpdate(style);
            }
        };
        this.styler = new StateStyler((StyleHandler)this.blinker);
    }

    private void handleDispose() {
        for (DetailsPart part : this.detailParts) {
            part.dispose();
        }
        this.disposeDataItem();
        this.resourceManager.dispose();
        this.styler.dispose();
        this.blinker.dispose();
    }

    public void setDataItem(Item item) {
        this.disposeDataItem();
        if (item != null) {
            if (this.headerLabel != null) {
                this.headerLabel.setText(String.format(Messages.DetailsViewComposite_DataItemFormat, item.getId()));
                this.headerValueLabel.setText("");
            }
            this.updateData(null);
            this.dataItem = new DataItemHolder(Activator.getDefault().getBundle().getBundleContext(), item, new DataSourceListener(){

                public void updateData(DataItemValue value) {
                    DetailsViewComposite.this.updateData(value);
                }
            });
            for (DetailsPart part : this.detailParts) {
                part.setDataItem(this.dataItem);
            }
        } else {
            if (this.headerLabel != null) {
                this.headerLabel.setText(Messages.DetailsViewComposite_EmptyDataItem);
                this.headerValueLabel.setText("");
            }
            for (DetailsPart part : this.detailParts) {
                part.setDataItem(null);
            }
        }
    }

    protected void updateData(final DataItemValue value) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                DetailsViewComposite.this.updateHeader(value);
                for (DetailsPart part : DetailsViewComposite.this.detailParts) {
                    part.updateData(value);
                }
            }
        });
    }

    protected void handleStyleUpdate(StyleBlinker.CurrentStyle style) {
        if (this.header.isDisposed()) {
            return;
        }
        DetailsViewComposite.applyWidget((Control)this.headerValueLabel, style);
        DetailsViewComposite.applyWidget((Control)this.header, style);
        DetailsViewComposite.applyWidget((Control)this.headerLabel, style);
        DetailsViewComposite.applyWidget(this.headerIcon, style);
        this.header.layout();
    }

    private static void applyWidget(Label label, StyleBlinker.CurrentStyle style) {
        DetailsViewComposite.applyWidget((Control)label, style);
        label.setImage(style.image);
    }

    private static void applyWidget(Control label, StyleBlinker.CurrentStyle style) {
        label.setForeground(style.foreground);
        label.setBackground(style.background);
        label.setFont(style.font);
    }

    private void updateHeader(DataItemValue value) {
        if (this.headerValueLabel.isDisposed()) {
            return;
        }
        this.styler.style((StateInformation)new DataItemValueStateExtractor(value));
        if (value == null) {
            this.headerValueLabel.setText(Messages.DetailsViewComposite_NoValueText);
            return;
        }
        this.headerValueLabel.setText(value.toString());
        this.header.layout();
    }

    private void disposeDataItem() {
        if (this.dataItem != null) {
            this.dataItem.dispose();
            this.dataItem = null;
        }
    }
}

