/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.view;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapCellLabelProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scada.ui.chart.view.AbstractChartManagePart;
import org.eclipse.scada.ui.chart.viewer.ChartViewer;
import org.eclipse.scada.ui.chart.viewer.input.ChartInput;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;

public class ChartControllerView
extends AbstractChartManagePart {
    private TableViewer viewer;
    private DataBindingContext dbc;

    public void createPartControl(Composite parent) {
        this.dbc = new DataBindingContext();
        parent.setLayout((Layout)new FillLayout());
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new FillLayout());
        this.viewer = new TableViewer(wrapper, 65536);
        this.viewer.getTable().setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        this.viewer.getTable().setLayout((Layout)layout);
        ObservableListContentProvider provider = new ObservableListContentProvider();
        this.viewer.setContentProvider((IContentProvider)provider);
        TableViewerColumn col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText("Input");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        col.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(BeansObservables.observeMap((IObservableSet)provider.getRealizedElements(), (String)"label")){

            public void update(ViewerCell cell) {
                cell.setText(((ChartInput)cell.getElement()).getLabel());
            }
        });
        col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText("Preview");
        col.getColumn().setAlignment(0x1000000);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(50));
        col.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(BeansObservables.observeMap((IObservableSet)provider.getRealizedElements(), (String)"preview")){

            public void update(ViewerCell cell) {
                Rectangle rect = cell.getImageBounds();
                if (rect != null && rect.width > 0 && rect.height > 0) {
                    cell.setImage(((ChartInput)cell.getElement()).getPreview(rect.width, rect.height));
                } else {
                    cell.setImage(((ChartInput)cell.getElement()).getPreview(50, 20));
                }
            }
        });
        col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText("State");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        col.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(BeansObservables.observeMap((IObservableSet)provider.getRealizedElements(), (String)"state")){

            public void update(ViewerCell cell) {
                cell.setText(((ChartInput)cell.getElement()).getState());
            }
        });
        col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText("Selected Timestamp");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        col.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(BeansObservables.observeMap((IObservableSet)provider.getRealizedElements(), (String)"selectedTimestamp")){

            public void update(ViewerCell cell) {
                Date timestamp = ((ChartInput)cell.getElement()).getSelectedTimestamp();
                cell.setText(timestamp == null ? null : DateFormat.getDateTimeInstance().format(timestamp));
            }
        });
        col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText("Selected Value");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        col.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(BeansObservables.observeMap((IObservableSet)provider.getRealizedElements(), (String)"selectedValue")){

            public void update(ViewerCell cell) {
                cell.setText(((ChartInput)cell.getElement()).getSelectedValue());
            }
        });
        col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText("Selected Quality");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        col.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(BeansObservables.observeMap((IObservableSet)provider.getRealizedElements(), (String)"selectedQuality")){

            public void update(ViewerCell cell) {
                cell.setText(((ChartInput)cell.getElement()).getSelectedQuality());
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.contribueTo(this.getViewSite());
        this.attachSelectionService();
    }

    public void dispose() {
        this.dbc.dispose();
        super.dispose();
    }

    @Override
    protected void setChartViewer(ChartViewer chartViewer) {
        if (chartViewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setInput((Object)chartViewer.getItems());
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void hookContextMenu(IViewSite viewSite) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ChartControllerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        viewSite.registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void contribueTo(IViewSite viewSite) {
        this.hookContextMenu(viewSite);
    }
}

