/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.view.action;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.da.ui.connection.data.ItemSelectionHelper;
import org.eclipse.scada.ui.chart.view.AbstractChartView;
import org.eclipse.scada.ui.chart.view.Activator;
import org.eclipse.scada.ui.chart.view.ChartView;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenChartAction
implements IViewActionDelegate,
IObjectActionDelegate {
    private static final Logger logger = LoggerFactory.getLogger(OpenChartAction.class);
    private IWorkbenchPartSite site = null;
    private IStructuredSelection selection = null;

    public void init(IViewPart view) {
        this.site = view.getSite();
    }

    public void run(IAction action) {
        if (this.selection == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Item item : ItemSelectionHelper.getSelection((ISelection)this.selection)) {
            sb.append(item.getId());
        }
        String secondaryId = sb.toString();
        secondaryId = secondaryId.replace("_", "__");
        secondaryId = secondaryId.replace(":", "_");
        try {
            IViewPart viewer = this.site.getPage().showView("org.eclipse.scada.ui.chart.ChartView", secondaryId, 1);
            for (Item item : ItemSelectionHelper.getSelection((ISelection)this.selection)) {
                if (!(viewer instanceof ChartView)) continue;
                ((AbstractChartView)viewer).addItem(item);
            }
        }
        catch (PartInitException e) {
            logger.error("Failed to create view", (Throwable)e);
            Activator.getDefault().getLog().log(e.getStatus());
        }
        catch (Exception e) {
            logger.error("Failed to create view", (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.scada.ui.chart.model.view", 1, "Failed to create chart view", (Throwable)e));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.site = targetPart.getSite();
    }
}

