/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.config;

import java.util.Map;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.scada.ae.ui.views.views.LabelProviderSupport;
import org.eclipse.scada.ae.ui.views.views.table.EntryTimestampLabelProvider;
import org.eclipse.scada.ae.ui.views.views.table.IdLabelProvider;
import org.eclipse.scada.ae.ui.views.views.table.SourceTimestampLabelProvider;
import org.eclipse.scada.ae.ui.views.views.table.VariantLabelProvider;

public class ColumnLabelProviderInformation {
    private final String label;
    private final String type;
    private final Map<String, String> parameters;
    private final boolean sortable;
    private final int initialSize;
    public static final String TYPE_ID = "id";
    public static final String TYPE_SOURCE_TIMESTAMP = "sourceTimestamp";
    public static final String TYPE_ENTRY_TIMESTAMP = "entryTimestamp";
    public static final String TYPE_VARIANT = "variant";

    public ColumnLabelProviderInformation(String label, String type, boolean sortable, int initialSize, Map<String, String> parameters) {
        this.label = label;
        this.type = type;
        this.parameters = parameters;
        this.sortable = sortable;
        this.initialSize = initialSize;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public String getLabel() {
        return this.label;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getType() {
        return this.type;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public CellLabelProvider createLabelProvider(LabelProviderSupport labelProviderSupport) {
        if (TYPE_ID.equals(this.type)) {
            return new IdLabelProvider();
        }
        if (TYPE_SOURCE_TIMESTAMP.equals(this.type)) {
            return new SourceTimestampLabelProvider(labelProviderSupport);
        }
        if (TYPE_ENTRY_TIMESTAMP.equals(this.type)) {
            return new EntryTimestampLabelProvider(labelProviderSupport);
        }
        if (TYPE_VARIANT.equals(this.type)) {
            String key = this.parameters.get("key");
            String decorationString = this.parameters.get("decoration");
            VariantLabelProvider.Decoration decoration = decorationString == null || decorationString.isEmpty() ? null : VariantLabelProvider.Decoration.valueOf(decorationString);
            return new VariantLabelProvider(key, labelProviderSupport, decoration);
        }
        return null;
    }
}

