/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.views.tree;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.scada.core.ui.connection.Activator;
import org.eclipse.scada.core.ui.connection.data.ConnectionDiscovererBean;
import org.eclipse.scada.core.ui.connection.views.tree.ConnectionPoolManager;
import org.eclipse.scada.core.ui.connection.views.tree.DiscovererListener;
import org.eclipse.scada.core.ui.connection.views.tree.TreeNode;
import org.eclipse.scada.core.ui.connection.views.tree.node.AllConnectionsNode;
import org.eclipse.scada.core.ui.connection.views.tree.node.GroupingNode;
import org.eclipse.scada.core.ui.connection.views.tree.node.TargetGroupingProvider;
import org.eclipse.scada.core.ui.connection.views.tree.node.UriGroupingProvider;

public class ConnectionTreeManager {
    private final IObservableSet discoverers;
    private final ISetChangeListener listener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            ConnectionTreeManager.this.handleDiff(event.diff);
        }
    };
    private final Map<ConnectionDiscovererBean, DiscovererListener> listenerMap = new HashMap<ConnectionDiscovererBean, DiscovererListener>();
    private final Realm realm;
    private final WritableSet treeRoot;
    private final ConnectionPoolManager poolManager;

    public ConnectionTreeManager(final WritableSet treeRoot) {
        this.realm = treeRoot.getRealm();
        this.treeRoot = treeRoot;
        this.poolManager = new ConnectionPoolManager(this.realm);
        this.discoverers = Activator.getDefault().getDiscovererSet();
        this.discoverers.addSetChangeListener(this.listener);
        this.handleDiff(Diffs.createSetDiff((Set)this.discoverers, Collections.emptySet()));
        treeRoot.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConnectionTreeManager.this.addInitial(treeRoot);
            }
        });
    }

    private void addInitial(WritableSet treeRoot) {
        treeRoot.add((Object)new AllConnectionsNode(this.realm, this.poolManager));
        treeRoot.add((Object)new GroupingNode(this.realm, "By URI", this.poolManager, new UriGroupingProvider()));
        treeRoot.add((Object)new GroupingNode(this.realm, "By Target", this.poolManager, new TargetGroupingProvider()));
    }

    public void dispose() {
        this.realm.exec(new Runnable(){

            @Override
            public void run() {
                ConnectionTreeManager.this.handleDispose();
            }
        });
    }

    private void handleDispose() {
        this.discoverers.removeSetChangeListener(this.listener);
        this.poolManager.dispose();
        for (Object o : this.treeRoot) {
            if (!(o instanceof TreeNode)) continue;
            ((TreeNode)o).dispose();
        }
        this.treeRoot.clear();
    }

    protected void handleDiff(SetDiff diff) {
        for (Object o : diff.getAdditions()) {
            this.handleAdd((ConnectionDiscovererBean)o);
        }
        for (Object o : diff.getRemovals()) {
            this.handleRemove((ConnectionDiscovererBean)o);
        }
    }

    private void handleRemove(ConnectionDiscovererBean connectionDiscoverer) {
        DiscovererListener listener = this.listenerMap.remove(connectionDiscoverer);
        if (listener != null) {
            listener.dispose();
        }
    }

    private void handleAdd(ConnectionDiscovererBean connectionDiscoverer) {
        DiscovererListener listener = new DiscovererListener(connectionDiscoverer, this.poolManager);
        this.listenerMap.put(connectionDiscoverer, listener);
    }
}

