/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.ui.connection.ConnectionDescriptor;
import org.eclipse.scada.core.ui.connection.wizards.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AddConnectionWizardPage1
extends WizardPage {
    private Text uriText;
    private ConnectionDescriptor connectionInformation;
    private Text idText;
    private final ModifyListener updateListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AddConnectionWizardPage1.this.update();
        }
    };

    protected AddConnectionWizardPage1(ConnectionDescriptor preset) {
        super(Messages.AddConnectionWizardPage1_PageTitle);
        this.setTitle(Messages.AddConnectionWizardPage1_PageTitle);
        this.setDescription(Messages.AddConnectionWizardPage1_PageDescription);
        this.connectionInformation = preset;
    }

    public ConnectionDescriptor getConnectionInformation() {
        return this.connectionInformation;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(comp, 0);
        label.setText(Messages.AddConnectionWizardPage1_ConnectionUriLabel);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.uriText = new Text(comp, 2048);
        this.uriText.setMessage(Messages.AddConnectionWizardPage1_ConnectionUriMessage);
        this.uriText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(comp, 0);
        label.setText(Messages.AddConnectionWizardPage1_ConnectionIdLabel);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.idText = new Text(comp, 2048);
        this.idText.setMessage(Messages.AddConnectionWizardPage1_ConnectionIdMessage);
        this.idText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.connectionInformation != null && this.connectionInformation.getConnectionInformation() != null) {
            this.uriText.setText(this.connectionInformation.getConnectionInformation().toMaskedString());
            if (this.connectionInformation.getServiceId() != null) {
                this.idText.setText(this.connectionInformation.getServiceId());
            }
        } else {
            this.uriText.setText("da:ngp://localhost:2101");
        }
        this.uriText.addModifyListener(this.updateListener);
        this.idText.addModifyListener(this.updateListener);
        this.setControl((Control)comp);
        this.update();
    }

    public void update() {
        String errorMessage = null;
        try {
            String id = this.idText.getText();
            if (id.isEmpty()) {
                id = null;
            }
            this.connectionInformation = new ConnectionDescriptor(ConnectionInformation.fromURI((String)this.uriText.getText()), id, null);
        }
        catch (Throwable e) {
            errorMessage = e.getLocalizedMessage();
        }
        this.setState(errorMessage);
    }

    private void setState(String errorMessage) {
        if (errorMessage == null) {
            this.setPageComplete(true);
            this.setMessage(Messages.AddConnectionWizardPage1_InformationMessage, 1);
        } else {
            this.setPageComplete(false);
            this.setMessage(errorMessage, 3);
        }
    }
}

