/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.chart.draw2d;

import org.eclipse.draw2d.Figure;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.ui.chart.model.Chart;
import org.eclipse.scada.ui.chart.model.ChartFactory;
import org.eclipse.scada.ui.chart.model.XAxis;
import org.eclipse.scada.ui.chart.model.YAxis;
import org.eclipse.scada.ui.chart.viewer.ChartViewer;
import org.eclipse.scada.ui.chart.viewer.ExtensionSpaceProvider;
import org.eclipse.scada.ui.chart.viewer.NullExtensionSpace;
import org.eclipse.scada.vi.ui.chart.draw2d.Draw2DGraphics;
import org.eclipse.scada.vi.ui.chart.draw2d.FigureRenderer;
import org.eclipse.swt.graphics.Rectangle;

public class ChartFigure
extends Figure {
    private ChartRenderer renderer;
    private ChartViewer viewer;
    private Chart configuration;
    private boolean realize;

    public void setConfiguration(Chart configuration) {
        this.doDisposeRenderer();
        this.configuration = configuration;
        this.checkCreate();
    }

    public void addNotify() {
        super.addNotify();
        this.createRenderer();
    }

    public void removeNotify() {
        this.disposeRenderer();
        super.removeNotify();
    }

    private static Chart makeDefaultConfiguration() {
        Chart configuration = ChartFactory.eINSTANCE.createChart();
        YAxis y = ChartFactory.eINSTANCE.createYAxis();
        y.setLabel("Values");
        configuration.getLeft().add((Object)y);
        XAxis x = ChartFactory.eINSTANCE.createXAxis();
        x.setLabel("Time");
        x.setFormat("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL");
        x.setMinimum(System.currentTimeMillis());
        x.setMaximum(System.currentTimeMillis() + 900000L);
        configuration.getBottom().add((Object)x);
        configuration.setSelectedXAxis(x);
        configuration.setSelectedYAxis(y);
        return configuration;
    }

    protected void disposeRenderer() {
        this.realize = false;
        this.doDisposeRenderer();
    }

    private void doDisposeRenderer() {
        if (this.viewer != null) {
            this.viewer.dispose();
            this.viewer = null;
        }
        if (this.renderer != null) {
            this.renderer.dispose();
            this.renderer = null;
        }
    }

    protected void createRenderer() {
        this.disposeRenderer();
        this.realize = true;
        this.checkCreate();
    }

    private void doCreateRenderer() {
        this.renderer = new FigureRenderer(this);
        this.viewer = new ChartViewer(this.renderer, this.configuration != null ? this.configuration : ChartFigure.makeDefaultConfiguration(), (ExtensionSpaceProvider)new NullExtensionSpace(), null);
    }

    private void checkCreate() {
        if (this.configuration != null && this.realize) {
            this.doCreateRenderer();
        }
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        if (this.renderer != null) {
            this.renderer.resizeAll(new Rectangle(0, 0, w, h));
        }
    }

    protected void paintClientArea(org.eclipse.draw2d.Graphics graphics) {
        if (this.renderer != null) {
            Draw2DGraphics g = new Draw2DGraphics(graphics);
            this.renderer.paint((Graphics)g);
        }
    }
}

