/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.impl;

import java.net.URL;
import java.util.Collection;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.UnionSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.scada.core.ui.connection.login.SessionManager;
import org.eclipse.scada.utils.script.ScriptExecutor;
import org.eclipse.scada.vi.details.DetailView;
import org.eclipse.scada.vi.details.model.Component;
import org.eclipse.scada.vi.details.model.GroupEntry;
import org.eclipse.scada.vi.details.model.HiddenComponent;
import org.eclipse.scada.vi.details.model.ScriptModule;
import org.eclipse.scada.vi.details.model.View;
import org.eclipse.scada.vi.details.swt.Activator;
import org.eclipse.scada.vi.details.swt.DetailComponent;
import org.eclipse.scada.vi.details.swt.data.DataItemDescriptor;
import org.eclipse.scada.vi.details.swt.impl.DetailComponentImpl;
import org.eclipse.scada.vi.details.swt.impl.GroupTab;
import org.eclipse.scada.vi.details.swt.impl.GroupTabImpl;
import org.eclipse.scada.vi.details.swt.impl.RealTimeGroupTab;
import org.eclipse.scada.vi.details.swt.impl.tab.EclipseTabProvider;
import org.eclipse.scada.vi.details.swt.impl.tab.NativeTabProvider;
import org.eclipse.scada.vi.details.swt.impl.tab.TabProvider;
import org.eclipse.scada.vi.details.swt.impl.visibility.ComponentVisibility;
import org.eclipse.scada.vi.details.swt.impl.visibility.TabVisibleComponent;
import org.eclipse.scada.vi.details.swt.impl.visibility.VisibilityProvider;
import org.eclipse.scada.vi.details.swt.impl.visibility.VisibilityProviderFactory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailViewImpl
implements DetailView,
IExecutableExtension {
    private static final Logger logger = LoggerFactory.getLogger(DetailViewImpl.class);
    private static final String realtimeListRole = System.getProperty("org.eclipse.scada.vi.details.swt.impl.roles.realtimeList", "admin");
    private String uri;
    private DetailComponent header;
    private final List<GroupTab> groups = new LinkedList<GroupTab>();
    private RealTimeGroupTab realTimeTab;
    private EList<HiddenComponent> hiddenItems;
    private VisibilityProviderFactory visibleFactory;
    private final Collection<ComponentVisibility> visibilities = new LinkedList<ComponentVisibility>();
    private EList<ScriptModule> scriptModuels;
    private View view;

    public void dispose() {
        if (this.header != null) {
            this.header.dispose();
        }
        for (GroupTab group : this.groups) {
            group.dispose();
        }
        for (ComponentVisibility visibility : this.visibilities) {
            visibility.dispose();
        }
    }

    public void init(Composite parent, Map<String, String> properties) {
        try {
            ScriptEngineManager engineManager = new ScriptEngineManager(Activator.class.getClassLoader());
            SimpleScriptContext scriptContext = new SimpleScriptContext();
            scriptContext.setBindings(new SimpleBindings(), 200);
            scriptContext.setAttribute("properties", properties, 200);
            this.visibleFactory = new VisibilityProviderFactory(engineManager, scriptContext, properties);
            this.load();
            for (ScriptModule module : this.scriptModuels) {
                this.loadScriptModule(engineManager, scriptContext, module);
            }
            Composite box = new Composite(parent, 0);
            box.setLayout((Layout)new GridLayout(1, false));
            LinkedList<Object> lists = new LinkedList<Object>();
            WritableSet hiddenItems = new WritableSet();
            lists.add(hiddenItems);
            for (HiddenComponent hidden : this.hiddenItems) {
                String item = DetailComponentImpl.resolve(hidden.getDescriptor(), properties);
                hiddenItems.add((Object)DataItemDescriptor.create(item));
            }
            if (this.header != null) {
                Composite wrapper = new Composite(box, 0);
                wrapper.setLayout((Layout)new FillLayout());
                wrapper.setLayoutData((Object)new GridData(4, 4, true, false));
                this.header.init(this.visibleFactory, wrapper, properties);
                lists.add(this.header.getDescriptors());
                this.header.start();
            }
            TabProvider tabProvider = this.createTabProvider(box);
            int i = 0;
            for (GroupTab group : this.groups) {
                TabProvider.Folder folder = tabProvider.createFolder(i, group.getLabel());
                group.init(this.visibleFactory, folder.getContainer(), properties);
                VisibilityProvider provider = this.visibleFactory.createProvider(group.getVisibility());
                TabVisibleComponent component = new TabVisibleComponent(folder, i, group, (Control)folder.getContainer());
                folder.setSummaryProvider(component.getSummaryProvider());
                ComponentVisibility visibility = new ComponentVisibility(provider, component);
                this.addVisibility(visibility);
                lists.add(visibility.getDescriptors());
                ++i;
            }
            this.realTimeTab.setInput((IObservableSet)new UnionSet(lists.toArray(new IObservableSet[lists.size()])));
        }
        catch (Exception e) {
            logger.warn("Failed to load view", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private TabProvider createTabProvider(Composite parent) {
        if (this.view.getTabStyle() == null) {
            return this.defaultTabProvider(parent);
        }
        switch (this.view.getTabStyle()) {
            case DEFAULT: {
                return this.defaultTabProvider(parent);
            }
            case NATIVE: {
                return new NativeTabProvider(parent);
            }
            case ENHANCED: {
                return new EclipseTabProvider(parent);
            }
        }
        return this.defaultTabProvider(parent);
    }

    private TabProvider defaultTabProvider(Composite parent) {
        if (!Boolean.getBoolean("org.eclipse.scada.vi.details.swt.defaultEnhancedTabs")) {
            return new NativeTabProvider(parent);
        }
        return new EclipseTabProvider(parent);
    }

    private void loadScriptModule(ScriptEngineManager engineManager, ScriptContext scriptContext, ScriptModule module) throws Exception {
        String engineName = module.getScriptLanguage();
        if (engineName == null || engineName.isEmpty()) {
            engineName = "JavaScript";
        }
        if (module.getCode() != null && !module.getCode().isEmpty()) {
            new ScriptExecutor(engineManager, engineName, module.getCode(), Activator.class.getClassLoader()).execute(scriptContext);
        }
        if (module.getCodeUri() != null && !module.getCodeUri().isEmpty()) {
            new ScriptExecutor(engineManager, engineName, new URL(module.getCodeUri()), Activator.class.getClassLoader()).execute(scriptContext);
        }
    }

    private void addVisibility(ComponentVisibility visibility) {
        this.visibilities.add(visibility);
        visibility.start();
    }

    private void load() {
        logger.info("Loading: {}", (Object)this.uri);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI file = URI.createURI((String)this.uri);
        Resource resource = resourceSet.getResource(file, true);
        for (EObject o : resource.getContents()) {
            if (!(o instanceof View)) continue;
            this.createView((View)o);
        }
    }

    private void createView(View view) {
        this.view = view;
        this.scriptModuels = view.getScriptModule();
        this.hiddenItems = view.getHiddenComponent();
        this.header = this.createComponent(view.getHeaderComponent());
        this.realTimeTab = new RealTimeGroupTab();
        for (GroupEntry group : view.getGroups()) {
            DetailComponent component = this.createComponent(group.getComponent());
            if (component == null) continue;
            GroupTabImpl groupTab = new GroupTabImpl(group.getLabel(), component, group.getVisibility());
            if (group.getPermission() == null) {
                this.groups.add(groupTab);
                continue;
            }
            if (!SessionManager.getDefault().hasRole(group.getPermission())) continue;
            this.groups.add(groupTab);
        }
        if (SessionManager.getDefault().hasRole(realtimeListRole)) {
            this.groups.add(this.realTimeTab);
        }
    }

    private DetailComponent createComponent(Component component) {
        if (component == null) {
            return null;
        }
        return new DetailComponentImpl(component);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.uri = "" + data;
        } else if (data instanceof Dictionary) {
            this.uri = "" + ((Dictionary)data).get("uri");
        }
    }
}

