/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.importer.wizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scada.ca.connection.provider.ConnectionService;
import org.eclipse.scada.ca.oscar.OscarLoader;
import org.eclipse.scada.ca.ui.importer.wizard.Messages;
import org.eclipse.scada.ca.ui.util.DiffController;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;

public class LocalDataPage
extends WizardPage {
    private Text fileName;
    private final DiffController mergeController;
    private Label dataLabel;
    private final ConnectionService service;

    protected LocalDataPage(ConnectionService service, DiffController mergeController) {
        super("welcomePage");
        this.service = service;
        this.setTitle(Messages.LocalDataPage_Title);
        this.mergeController = mergeController;
    }

    public void createControl(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(wrapper, 0);
        label.setText(Messages.LocalDataPage_FileLabel);
        this.fileName = new Text(wrapper, 2048);
        String file = this.loadFileFromPreferences();
        if (file != null) {
            this.fileName.setText(file);
        }
        this.fileName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocalDataPage.this.update();
            }
        });
        Button selectButton = new Button(wrapper, 8);
        selectButton.setText(Messages.LocalDataPage_BrowseButtonText);
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalDataPage.this.selectFile();
            }
        });
        Button loadButton = new Button(wrapper, 8);
        loadButton.setText(Messages.LocalDataPage_LoadButtonText);
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalDataPage.this.loadFile();
            }
        });
        this.setControl((Control)wrapper);
        this.dataLabel = new Label(wrapper, 0);
        this.dataLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.update();
    }

    protected void selectFile() {
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        dlg.setFilterExtensions(new String[]{"*.oscar", "*.json", "*.*"});
        dlg.setFilterNames(new String[]{Messages.LocalDataPage_OSCARFilterDescription, Messages.LocalDataPage_JSONFilterDescription, Messages.LocalDataPage_AllFilterDescription});
        if (this.fileName.getText().length() > 0) {
            dlg.setFileName(this.fileName.getText());
        }
        dlg.setFilterIndex(0);
        String file = dlg.open();
        if (file != null) {
            this.fileName.setText(file);
            this.storeFileToPreferences(file);
            this.loadFile();
        }
    }

    private String loadFileFromPreferences() {
        return this.getWizard().getDialogSettings().get(this.makeKey());
    }

    private String makeKey() {
        try {
            return "welcomePage.file." + this.service.getConnection().getConnectionInformation().toMaskedString();
        }
        catch (Exception exception) {
            return "welcomePage.file";
        }
    }

    private void storeFileToPreferences(String file) {
        this.getWizard().getDialogSettings().put(this.makeKey(), file);
    }

    protected void update() {
        try {
            this.validate();
            this.setMessage(null, 0);
            this.setPageComplete(this.mergeController.getLocalData() != null);
        }
        catch (Exception e) {
            this.setMessage(e.getLocalizedMessage(), 3);
            this.setPageComplete(false);
        }
        Map localData = this.mergeController.getLocalData();
        if (localData != null) {
            this.dataLabel.setText(String.format(Messages.LocalDataPage_StatusLabelFormat, localData.size()));
        } else {
            this.dataLabel.setText(Messages.LocalDataPage_EmptyStatusLabelText);
        }
    }

    protected File getFile() {
        return new File(this.fileName.getText());
    }

    private void validate() throws Exception {
        String fileName = this.fileName.getText();
        if (fileName.length() == 0) {
            throw new IllegalStateException(Messages.LocalDataPage_ErrorMissingFile);
        }
        File file = new File(fileName);
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format(Messages.LocalDataPage_ErrorNonExistingFile, fileName));
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(String.format(Messages.LocalDataPage_ErrorNormalFile, fileName));
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(String.format(Messages.LocalDataPage_ErrorCannotReadFile, fileName));
        }
        if (this.mergeController.getLocalData() == null) {
            throw new IllegalStateException(Messages.LocalDataPage_ErrorNoData);
        }
    }

    protected void loadFile() {
        try {
            this.mergeController.setLocalData(null);
            final File file = this.getFile();
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(Messages.LocalDataPage_TaskName, -1);
                            LocalDataPage.this.loadData(file);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.scada.ca.ui.importer", Messages.LocalDataPage_StatusErrorFailedToLoad, (Throwable)e);
            StatusManager.getManager().handle((IStatus)status, 4);
        }
        this.update();
    }

    protected void loadData(File file) throws Exception {
        if (OscarLoader.isOscar((File)file)) {
            OscarLoader loader = new OscarLoader(file);
            this.mergeController.setLocalData(loader.getData());
            this.mergeController.setIgnoreFields(loader.getIgnoreFields());
        } else {
            FileInputStream stream = new FileInputStream(file);
            try {
                this.mergeController.setLocalData(OscarLoader.loadJsonData((InputStream)stream));
            }
            finally {
                ((InputStream)stream).close();
            }
        }
    }
}

