/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.user.navigation;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.core.ui.styles.StateInformation;
import org.eclipse.scada.core.ui.styles.StateStyler;
import org.eclipse.scada.core.ui.styles.StyleBlinker;
import org.eclipse.scada.core.ui.styles.StyleHandler;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.vi.data.SummaryProvider;
import org.eclipse.scada.vi.ui.user.Activator;
import org.eclipse.scada.vi.ui.user.navigation.DelegatingSummaryProvider;
import org.eclipse.scada.vi.ui.user.navigation.ItemSummaryProvider;
import org.eclipse.scada.vi.ui.user.navigation.StateListener;
import org.eclipse.scada.vi.ui.user.navigation.StateProvider;
import org.eclipse.scada.vi.ui.user.navigation.ToolBarNavigator;
import org.eclipse.scada.vi.ui.user.viewer.ViewInstance;
import org.eclipse.scada.vi.ui.user.viewer.ViewInstanceDescriptor;
import org.eclipse.scada.vi.ui.user.viewer.ViewManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolBarNavigatorItem
implements StateListener {
    private static final Logger logger = LoggerFactory.getLogger(ToolBarNavigatorItem.class);
    private ToolItem button;
    private final ViewManager viewManager;
    private final ResourceManager manager;
    private final Image imageOk;
    private final Image imageInactive;
    private final StyleBlinker blinker;
    private final ViewInstanceDescriptor descriptor;
    private final ToolBar toolbar;
    private Image currentButtonImage;
    private boolean lazy = true;
    private boolean active;
    private final ToolBarNavigator toolBarNavigator;
    private final ViewInstance instance;
    private StateProvider summaryProvider;
    private Image styleImage;
    private boolean lazySummary;
    private final StateStyler styler;

    public ToolBarNavigatorItem(ToolBarNavigator toolBarNavigator, ToolBar toolbar, int index, ViewManager viewManager, ViewInstance viewInstance, ResourceManager manager) {
        this.toolBarNavigator = toolBarNavigator;
        this.toolbar = toolbar;
        this.viewManager = viewManager;
        this.manager = manager;
        this.instance = viewInstance;
        this.descriptor = viewInstance.getDescriptor();
        this.button = new ToolItem(toolbar, 16, index);
        this.button.setText(this.descriptor.getName());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolBarNavigatorItem.this.showView(ToolBarNavigatorItem.this.descriptor.getId());
            }
        });
        this.imageOk = this.createImage("image.ok");
        this.imageInactive = this.createImage("image.inactive");
        this.button.setImage(this.imageInactive);
        this.createToolbarButton();
        this.blinker = new StyleBlinker(){

            public void update(StyleBlinker.CurrentStyle style) {
                ToolBarNavigatorItem.this.handleUpdateStyle(style);
            }
        };
        this.styler = new StateStyler((StyleHandler)this.blinker);
        this.lazy = viewInstance.isLazy();
        this.active = viewInstance.isActive();
        this.blinker.setStyle(null);
        if (this.descriptor.getSummaryConnectionId() != null && this.descriptor.getSummaryItemId() != null) {
            logger.info("Creating summary provider using item: {} - {}", (Object)this.descriptor.getSummaryConnectionId(), (Object)this.descriptor.getSummaryItemId());
            this.summaryProvider = new ItemSummaryProvider(this, new Item(this.descriptor.getSummaryConnectionId(), this.descriptor.getSummaryItemId(), Item.Type.ID));
        } else if (this.instance instanceof SummaryProvider) {
            logger.info("Creating summary provider using view summary information");
            this.summaryProvider = new DelegatingSummaryProvider((SummaryProvider)this.instance, this);
            this.lazySummary = true;
        }
    }

    public void dispose() {
        if (this.summaryProvider != null) {
            this.summaryProvider.dispose();
        }
        this.styler.dispose();
        this.blinker.dispose();
        this.button.dispose();
    }

    private Image createImage(String key) {
        try {
            String uri = Activator.getDefault().getPreferenceStore().getString(key);
            return this.manager.createImageWithDefault(ImageDescriptor.createFromURL((URL)new URL(uri)));
        }
        catch (MalformedURLException malformedURLException) {
            return this.manager.createImageWithDefault(ImageDescriptor.getMissingImageDescriptor());
        }
    }

    private void createToolbarButton() {
        if (this.button == null) {
            int index = this.toolBarNavigator.calculateToolbarIndex(this.descriptor);
            if (index < 0) {
                return;
            }
            this.button = new ToolItem(this.toolbar, 16, index);
            this.button.setText(this.descriptor.getName());
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolBarNavigatorItem.this.showView(ToolBarNavigatorItem.this.descriptor.getId());
                }
            });
            this.button.setImage(this.currentButtonImage);
        }
    }

    protected void showView(String id) {
        this.viewManager.showView(id);
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
        this.setButtonImage(this.styleImage);
    }

    public void setActive(boolean active) {
        this.button.setSelection(active);
        this.active = active;
        this.setButtonImage(this.styleImage);
    }

    protected void handleUpdateStyle(StyleBlinker.CurrentStyle style) {
        logger.debug("Update Style");
        this.styleImage = style.image;
        this.setButtonImage(this.styleImage);
    }

    private void setButtonImage(Image image) {
        logger.debug("Setting button image for {} - image: {}, lazy: {}, active: {}", new Object[]{this.descriptor, image, this.lazy, this.active});
        this.currentButtonImage = image == null ? (this.lazy && this.lazySummary && !this.active ? this.imageInactive : this.imageOk) : image;
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setImage(this.currentButtonImage);
        }
    }

    @Override
    public void stateChange(StateInformation stateInformation) {
        logger.debug("Summary state changed: {}", (Object)stateInformation);
        this.styler.style(stateInformation);
    }
}

