/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.user.navigation.breadcrumb;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.scada.vi.ui.user.navigation.breadcrumb.BreadcrumbItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class BreadcrumbBar {
    private final Composite composite;
    private final boolean horizontal;
    private final ArrayList<BreadcrumbItem> items = new ArrayList();
    private final Set<BreadcrumbSelectionListener> selectionListeners = new LinkedHashSet<BreadcrumbSelectionListener>();

    public BreadcrumbBar(Composite parent, int style) {
        this.composite = new Composite(parent, 0);
        this.composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BreadcrumbBar.this.handleDispose();
            }
        });
        this.horizontal = (style & 0x100) != 0;
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        if (this.horizontal) {
            layout.marginWidth = 5;
            layout.horizontalSpacing = 5;
        } else {
            layout.marginHeight = 5;
            layout.verticalSpacing = 5;
        }
        this.composite.setLayout((Layout)layout);
    }

    public void addSelectionListener(BreadcrumbSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(BreadcrumbSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    protected void fireSelectionEvent(final BreadcrumbItem item) {
        for (final BreadcrumbSelectionListener listener : this.selectionListeners) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.selectionChanged(item);
                }
            });
        }
    }

    protected void handleDispose() {
        this.selectionListeners.clear();
    }

    public BreadcrumbItem[] getItems() {
        return this.items.toArray(new BreadcrumbItem[this.items.size()]);
    }

    public void setSelectionIndex(int selectionIndex) {
        this.selectItem(this.items.get(selectionIndex), true);
    }

    public void dispose() {
        this.composite.dispose();
    }

    Composite getComposite() {
        return this.composite;
    }

    public Control getControl() {
        return this.composite;
    }

    void addChild(BreadcrumbItem item) {
        this.items.add(item);
        if (this.horizontal) {
            ((GridLayout)this.composite.getLayout()).numColumns = this.items.size();
        }
        this.composite.layout();
    }

    void removeChild(BreadcrumbItem item) {
        this.items.remove(item);
        if (this.horizontal) {
            ((GridLayout)this.composite.getLayout()).numColumns = this.items.size();
        }
        this.composite.layout();
    }

    boolean isHorizontal() {
        return this.horizontal;
    }

    public void layout() {
        this.composite.layout();
    }

    public void selectItem(BreadcrumbItem item, boolean selected) {
        if (!this.items.contains(item)) {
            return;
        }
        for (BreadcrumbItem otherItem : this.items) {
            if (otherItem == item) continue;
            otherItem.handleSetSelection(false);
        }
        item.handleSetSelection(selected);
        if (selected) {
            this.fireSelectionEvent(item);
        }
    }

    public static interface BreadcrumbSelectionListener {
        public void selectionChanged(BreadcrumbItem var1);
    }
}

